<?php
include_once "inc/dbconn.php";
date_default_timezone_set('Africa/Nairobi');

if (!isset($_SESSION['uid'])) {
    echo "<script>alert('User not logged in'); location.href='login.php';</script>";
    exit;
}

$userid = $_SESSION['uid'];

$project_title = trim($_POST['project_title']);
$client = trim($_POST['client']);
$publish_status = isset($_POST['publish_status']) ? '1' : '0';
$meta_title = trim($_POST['meta_title']);
$meta_description = trim($_POST['meta_description']);
$description = trim($_POST['description']);
$what_we_provided = trim($_POST['what_we_provided']);
$challenge = trim($_POST['challenge']);
$features_list = trim($_POST['features_list']);
$faqs = trim($_POST['faqs']);

$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $project_title)));

if (empty($project_title)) {
    echo "<script>alert('Title should not be empty'); location.href='add_project.php';</script>";
    exit;
}

// Check duplicate
$check = $connection->query("SELECT id FROM portfolio_projects WHERE slug = '$slug'");
if ($check->num_rows > 0) {
    echo "<script>alert('A project with that title already exists. Please try a unique title.'); location.href='add_project.php';</script>";
    exit;
}

// Generate filename prefix
$title2 = substr(preg_replace('/[^A-Za-z0-9]/', '', $project_title), 0, 6);

// Save project description to file
$filename = $title2 . "@" . uniqid("veenproject", true) . ".txt";
$descPath = "../projects/" . $filename;
if (file_put_contents($descPath, $description) === false) {
    echo "<script>alert('Failed to write project description to file.'); location.href='projects.php';</script>";
    exit;
}

// Save meta description to file
$meta_name = $title2 . "@" . uniqid("_veenmeta", true) . ".txt";
$metaPath = "../metadesc/" . $meta_name;
if (file_put_contents($metaPath, $meta_description) === false) {
    echo "<script>alert('Failed to write meta description.'); location.href='projects.php';</script>";
    exit;
}

// Save what we provided to file
$what_name = $title2 . "@" . uniqid("_veenprovided", true) . ".txt";
$whatPath = "../projects/" . $what_name;
file_put_contents($whatPath, $what_we_provided);

// Save challenge to file
$challenge_name = $title2 . "@" . uniqid("_veenchallenge", true) . ".txt";
$challengePath = "../projects/" . $challenge_name;
file_put_contents($challengePath, $challenge);

// Process images
$all_files = glob("uploads/{$userid}/*.{jpg,jpeg,png,gif,jfif,webp}", GLOB_BRACE);
$targetDir = "../project_images/";
$imageList = '';

if (!empty($all_files)) {
    foreach ($all_files as $image_path) {
        $imageRealName = basename($image_path);
        $ext = strtolower(pathinfo($imageRealName, PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'jfif', 'webp'];

        if (in_array($ext, $allowed)) {
            $fileName = $title2 . "_veen_" . uniqid(true) . "." . $ext;
            $targetFilePath = $targetDir . $fileName;

            if (rename($image_path, $targetFilePath)) {
                $imageList .= $fileName . ",";
            } else {
                file_put_contents("image_errors.log", "Failed to move $image_path\n", FILE_APPEND);
            }
        } else {
            file_put_contents("image_errors.log", "Unsupported file type: $image_path\n", FILE_APPEND);
        }
    }
}

$imageList = rtrim($imageList, ',');

// Insert into DB
$stmt = $connection->prepare("
    INSERT INTO portfolio_projects (
        project_title, slug, description_file, image_files, publish_status,
        meta_title, meta_description_file, client,
        what_we_provided_file, challenge_file, features_list, faqs
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "ssssisssssss",
    $project_title, $slug, $filename, $imageList, $publish_status,
    $meta_title, $meta_name, $client,
    $what_name, $challenge_name, $features_list, $faqs
);

if ($stmt->execute()) {
    echo "<script>alert('Project Added Successfully'); location.href='projects.php';</script>";
} else {
    file_put_contents("db_errors.log", "DB Error: " . $stmt->error . "\n", FILE_APPEND);
    echo "<script>alert('Failed to save project.'); location.href='projects.php';</script>";
}
?>
