<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>

<!-- Page content -->
<div id="page-content">
    <!-- Datatables Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
                <i class="fa fa-table"></i>Users<br><small>Create Users & Assign Privileges!</small>
            </h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li><a href="">Users</a></li>
    </ul>
    <!-- END Datatables Header -->

    <!-- Datatables Content -->
    <div class="block full">
        <div class="add_user_btn ">
            <a href="#"  onclick="$('#modal-add-user').modal('show');" class="text-decoration-none"> <h2><i class="fa fa-plus-circle text-success"></i><span class="ml-20">Add User</span></h2></a>
        </div>

        <div class="table-responsive">
            <table id="example-datatable" class="table table-vcenter table-condensed table-bordered">
                <thead>
                    <tr>
                        <th class="text-center">ID</th>
                        <th class="text-center"><i class="gi gi-user"></i></th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Permission</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sql = $connection -> query("SELECT * FROM admin WHERE username != 'canon' AND email != 'stellamurugililian@gmail.com' ORDER BY username ASC");
                    $count = mysqli_num_rows($sql);
                    while($row = $sql -> fetch_assoc()) {
                        $username = $row['username'];
                        $phone = $row['phone'];
                        $email = $row['email'];
                        $privileges = $row['privileges'];
                        $id = $row['id'];
                        $explode = explode(',', $privileges);
                        $permission = "";
                        foreach($explode as $pk) {
                            $get = $connection -> query("SELECT * FROM permission WHERE id = '$pk'");
                            while($rows = $get -> fetch_assoc()){
                                $permission .= $rows['permission'] . ", ";
                            }
                        }
                    
                    ?>
                    <?php ?>
                    <tr>
                        <td class="text-center"><?php echo $id; ?></td>
                        <td class="text-center"><img src="img/placeholders/avatars/avatar<?php echo rand(1, 16); ?>.jpg" alt="avatar" class="img-circle"></td>
                        <td><a href="javascript:void(0)"><?php echo $username ?></a></td>
                        <td><?php echo $email; ?></td>
                        <td><?php echo $phone; ?></td>
                        <td><?php echo $permission; ?></td>
                        <td class="text-center">
                            <div class="btn-group">
                                <a href="#" data-toggle="tooltip" title="Edit" data-id="<?php echo $id; ?>" id="edit_user" class="btn btn-xs btn-default"><i class="fa fa-pencil"></i></a>
                                <a href="javascript:void(0)" data-toggle="tooltip" title="Delete" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php 
                    }
                 ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- END Datatables Content -->
</div>
<!--Modal Content -->
<div id="modal-add-user" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Add User</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="save_user.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                    <fieldset>
                        <legend>Vital Info</legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Username</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="username" placeholder="Enter Username.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-email">Email</label>
                            <div class="col-md-8">
                                <input type="email" id="user-settings-email" name="email" class="form-control" placeholder="Enter Email Address.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Phone</label>
                            <div class="col-md-8">
                                <input type="text" name="phone" class="form-control" placeholder="Enter Phone Number.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Privileges</label>
                            <div class="col-md-8">
                                <?php 
                                $get_permission = $connection -> query("SELECT * FROM permission");
                                while($row = $get_permission->fetch_assoc()) {
                                    $permission = $row['permission'];
                                    $permission_id = $row['id'];
                                    echo '
                                    <input type="checkbox" name="privileges[]" id="" value="'.$permission_id.'"> '.$permission.'<br> <br>
                                    ';
                                }
                                ?>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Password </legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-password" name="password" class="form-control" placeholder="Please choose a complex one.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-repassword">Confirm Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-repassword" name="confirm_password" class="form-control" placeholder="..and confirm it!" required>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!--Edit user modal -->
<div id="modal-edit-user" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Edit User</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="edit_user_processor.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                    <?php
                        $new_uid = $_GET['user'];
                        $get_user = $connection -> query("SELECT * FROM admin WHERE id = '$new_uid'");
                        while($rows = $get_user->fetch_assoc()) {
                            $username = $rows['username'];
                            $email = $rows['email'];
                            $phone = $rows['phone'];
                            $privileges = $rows['privileges'];
                            $explode = explode(',', $privileges);
                            $permission = "";
                        
                    ?>
                    <fieldset>
                        <legend>Vital Info</legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Username</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="username" value="<?php echo $username ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-email">Email</label>
                            <div class="col-md-8">
                                <input type="hidden" name="user_id" value="<?php echo $new_uid ?>">
                                <input type="email" id="user-settings-email" name="email" class="form-control" value="<?php echo $email ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Phone</label>
                            <div class="col-md-8">
                                <input type="text" name="phone" class="form-control" value="<?php echo $phone ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Privileges</label>
                            <div class="col-md-8">
                                <?php 
                                foreach($explode as $pk) {
                                
                                    $get_permission1 = $connection -> query("SELECT * FROM permission WHERE id = '$pk'");
                                    $qq = mysqli_num_rows($get_permission1);
                                    while($row1 = $get_permission1->fetch_assoc()) {
                                        $permission = $row1['permission'];
                                        $permission_id = $row1['id'];
                                        if($permission_id == $pk) {
                                            echo '
                                            <input type="checkbox" name="privileges[]" id="" value="'.$permission_id.'" checked> '.$permission.'<br> <br>
                                            ';
                                        } 
                                       
                                    }
                                    
                                }  
                              //Get permissions that are not allowed yet for this user
                                    $ids = join("','",$explode);
                                    $get_permission2 = $connection -> query("SELECT * FROM permission WHERE id NOT IN ('$ids')");
                                    $qq = mysqli_num_rows($get_permission2);
                                    while($row2 = $get_permission2->fetch_assoc()) {
                                        $permission2 = $row2['permission'];
                                        $permission_id2 = $row2['id'];

                                        echo '
                                        <input type="checkbox" name="privileges[]" id="" value="'.$permission_id2.'"> '.$permission2.'<br> <br>
                                        ';
                                        
                                    }
                                    
                                
                                ?>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Password </legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-password" name="password" class="form-control" placeholder="Please choose a complex one.." >
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-repassword">Confirm Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-repassword" name="confirm_password" class="form-control" placeholder="..and confirm it!" >
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Save Changes</button>
                        </div>
                    </div>
                    <?php } ?>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>

<?php include 'inc/template_end.php'; ?>

<script>
    $(document).ready(function(){
        $(document).on('click', '#edit_user', function(e){
            e.preventDefault();
            var user_id = $(this).attr('data-id');
            var pathname = window.location.href
            var url = new URL(pathname);
            url.searchParams.set("user", user_id); // setting your param
            var newUrl = url.href; 
            
            window.location.href = newUrl;
           
        })
        $.extend({
            getUrlVars: function(){
                var vars = [], hash;
                var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
                for(var i = 0; i < hashes.length; i++)
                {
                hash = hashes[i].split('=');
                vars.push(hash[0]);
                vars[hash[0]] = hash[1];
                }
                return vars;
            },
            getUrlVar: function(name){
                return $.getUrlVars()[name];
            }
        });

        if ($.getUrlVar("user") != null) {
            $('#modal-edit-user').modal('show');
        }
    })
</script>