<?php
include_once 'inc/dbconn.php'; // Database connection

$message = $_POST['message'];
$sendto = $_POST['sendto'];
$group_id = $_POST['group'];

// API credentials
$api_url = "https://sms.textsms.co.ke/api/services/sendbulk/";
$partnerID = "11179";
$apikey = "512994c5dd1710497411494567e87194";
$shortcode = "MOBITOP";

// Prepare recipient list
$numbers = [];

if (!empty($group_id)) {
    // Load contacts from file (group sending)
    $get_info = $connection->query("SELECT group_file_name FROM `groups` WHERE group_id = '$group_id'");
    $group_file_name = $get_info->fetch_assoc()['group_file_name'] ?? '';

    if (!empty($group_file_name) && file_exists('group_txt/' . $group_file_name . '.txt')) {
        $fh = fopen('group_txt/' . $group_file_name . '.txt', 'r');
        while ($line = fgets($fh)) {
            $contacts = explode(',', trim($line));
            foreach ($contacts as $contact) {
                $cleaned_number = preg_replace('/\D/', '', $contact);
                if (!empty($cleaned_number)) {
                    $numbers[] = $cleaned_number;
                }
            }
        }
        fclose($fh);
    }
} else {
    // Direct input
    $contacts = explode(',', $sendto);
    foreach ($contacts as $contact) {
        $cleaned_number = preg_replace('/\D/', '', trim($contact));
        if (!empty($cleaned_number)) {
            $numbers[] = $cleaned_number;
        }
    }
}

// Ensure numbers are unique to avoid duplicates

$numbers = array_unique($numbers);

// Split contacts into batches of 20
$chunks = array_chunk($numbers, 20);
$total_batches = count($chunks);

$mh = curl_multi_init();
$handles = [];
$batch_messages = []; // To store batch data for database insertion

$start_time = microtime(true); // Start tracking time

foreach ($chunks as $index => $batch) {
    $smslist = [];
    foreach ($batch as $mobile) {
        $client_sms_id = uniqid();
        $smslist[] = [
            "partnerID" => $partnerID,
            "apikey" => $apikey,
            "pass_type" => "plain",
            "clientsmsid" => $client_sms_id,
            "mobile" => $mobile,
            "message" => $message,
            "shortcode" => $shortcode
        ];
    }

    // Store batch messages for later saving
    $batch_messages[$index] = $smslist;

    // Prepare the bulk request
    $post_data = json_encode(["count" => count($smslist), "smslist" => $smslist]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

    curl_multi_add_handle($mh, $ch);
    $handles[$index] = $ch;
}

// Execute parallel requests
do {
    curl_multi_exec($mh, $running);
    curl_multi_select($mh);
} while ($running > 0);

// Prepare for bulk database insertion
$connection->begin_transaction();
$stmt = $connection->prepare("INSERT INTO sms_tracking (mobile, message, messageID, status, sent_at) VALUES (?, ?, ?, ?, NOW())");

$success_batches = 0;
foreach ($handles as $index => $ch) {
    $response = curl_multi_getcontent($ch);
    curl_multi_remove_handle($mh, $ch);
    curl_close($ch);

    // Decode API response
    $decodedResponse = json_decode($response, true);

    if (isset($decodedResponse['responses'])) {
        foreach ($decodedResponse['responses'] as $smsResponse) {
            $mobile = $smsResponse['mobile'];
            $messageID = $smsResponse['messageid'] ?? null;
            $status = $smsResponse['response-description'] ?? 'Unknown';

            if ($messageID) {
                $stmt->bind_param("ssss", $mobile, $message, $messageID, $status);
                $stmt->execute();
            } else {
                error_log("Warning: Missing messageID for mobile $mobile");
            }
        }
        $success_batches++;
    } else {
        error_log("Batch " . ($index + 1) . " failed: " . $response);
    }
}

// Commit all successful inserts
$stmt->close();
$connection->commit();
curl_multi_close($mh);

// Calculate execution time
$end_time = microtime(true);
$total_time = round(($end_time - $start_time) * 1000, 2);
echo "Sent $success_batches/$total_batches batches successfully in {$total_time}ms.<br>";

?>
