<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require "../../../vendor/autoload.php"; 

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../../inc/dbconn.php';


header('Content-Type: application/json');

if (empty($_POST['email'])) {
    echo json_encode(['status' => 'error', 'message' => 'Email is required.']);
    exit;
}

$email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid email format.']);
    exit;
}
$mail = new PHPMailer(true);
try {
    // Check if email already subscribed
    $check = $pdo->prepare("SELECT * FROM subscriptions WHERE email = ?");
    $check->execute([$email]);
    if ($check->rowCount() > 0) {
        echo json_encode(['status' => 'error', 'message' => 'You are already subscribed!']);
        exit;
    }

    // Insert new subscriber
    $stmt = $pdo->prepare("INSERT INTO subscriptions (email, status) VALUES (?, 'on')");
    $stmt->execute([$email]);

    // Send confirmation email
    $mail->isSMTP();
    $mail->Host = 'crownbeauty.ke';
    $mail->SMTPAuth = true;
    $mail->Username = 'mobitopk';
    $mail->Password = 'njirainicanon.m';
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;

    $mail->setFrom('info@crownbeauty.ke', 'W.Kirei');
    $mail->addAddress($email);
    $mail->isHTML(true);
    $mail->Subject = '🌸 Welcome to W.Kirei — Your Journey to Timeless Beauty Begins!';

    $mail->Body = '
    <div style="font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif; background-color:#fff8f9; color:#444; padding:40px 25px; border-radius:12px; border:1px solid #f5e2e7; max-width:600px; margin:auto; box-shadow:0 4px 12px rgba(0,0,0,0.05);">
        <div style="text-align:center; margin-bottom:30px;">
            <img src="https://yourdomain.com/assets/images/logo.png" alt="W.Kirei" style="height:60px; margin-bottom:10px;">
            <h2 style="color:#c06286; font-weight:600; margin:10px 0 5px;">Welcome to W.Kirei</h2>
            <p style="color:#666; font-size:15px; margin:0;">Where Japanese Science Meets Natural Elegance</p>
        </div>

        <div style="background-color:#fff; padding:25px; border-radius:10px; border:1px solid #f3d9df;">
            <h3 style="color:#c06286; text-align:center; margin-bottom:15px;">🎉 Here’s Your 30% OFF Coupon!</h3>
            <p style="font-size:15px; line-height:1.7; text-align:center; color:#555;">
                Thank you for subscribing to <strong>W.Kirei’s Newsletter</strong> — we’re so glad to have you on this journey toward radiant, healthy skin inspired by Japan’s beauty rituals.
            </p>

            <div style="text-align:center; margin:25px 0;">
                <div style="display:inline-block; background-color:#c06286; color:#fff; padding:14px 28px; border-radius:30px; font-size:18px; font-weight:600; letter-spacing:1px;">
                    WELCOME30
                </div>
                <p style="margin-top:10px; font-size:13px; color:#777;">Use this code at checkout to enjoy your exclusive 30% discount.</p>
            </div>

            <p style="font-size:15px; line-height:1.7; color:#555; text-align:center;">
                As part of our community, you’ll receive early access to new launches, exclusive beauty tips, and insights from Japan’s most advanced skincare science.
            </p>
        </div>

        <div style="margin-top:35px; text-align:center;">
            <p style="font-size:14px; color:#888; line-height:1.6;">
                From <strong>Tokyo</strong> to <strong>Nairobi</strong>, our mission is simple — <br>
                <em>to help every woman feel confident, radiant, and naturally beautiful.</em>
            </p>
            <p style="font-size:13px; color:#aaa; margin-top:20px;">© ' . date('Y') . ' W.Kirei Japan. All Rights Reserved.<br>
            Follow us on <a href="https://instagram.com" style="color:#c06286; text-decoration:none;">Instagram</a> • <a href="https://facebook.com" style="color:#c06286; text-decoration:none;">Facebook</a></p>
        </div>
    </div>
    ';


    $mail->send();

    echo json_encode(['status' => 'success', 'message' => 'Subscription successful! Check your email for confirmation.']);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Mailer error: ' . $e->getMessage()]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
