<?php
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
header('Content-Type: application/json');
header('Content-Type: application/json');
require_once '../../inc/dbconn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../../vendor/autoload.php'; // Make sure PHPMailer is installed via Composer

$reference = $_POST['reference'] ?? '';

if(!$reference){
    echo json_encode(['status'=>'error','message'=>'No reference provided']);
    exit;
}

// Verify with Paystack API
$secret_key = 'sk_test_b381e5bdf39d23cb3d41450fae2a0393a44053d0';
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/$reference",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secret_key"
    ]
]);
$response = curl_exec($curl);
curl_close($curl);

$res = json_decode($response, true);

if($res['status'] && $res['data']['status'] === 'success'){
    $pdo->beginTransaction();

    try {
        // Update payment record
        $stmt = $pdo->prepare("UPDATE paystack_payments SET status=?, transaction=?, message=? WHERE reference=?");
        $stmt->execute(['success', $res['data']['id'], json_encode($res['data']), $reference]);

        // Update order status
        $stmtOrder = $pdo->prepare("UPDATE orders SET status='paid' WHERE reference=?");
        $stmtOrder->execute([$reference]);

        $pdo->commit();

        // Fetch order info for email
        $stmtOrderInfo = $pdo->prepare("SELECT o.*, u.username FROM orders o JOIN users u ON u.id = o.user_id WHERE o.reference=?");
        $stmtOrderInfo->execute([$reference]);
        $order = $stmtOrderInfo->fetch(PDO::FETCH_ASSOC);

        // Fetch order items
        $stmtItems = $pdo->prepare("SELECT * FROM order_items WHERE order_id=?");
        $stmtItems->execute([$order['id']]);
        $items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);

        // ------------------- PHPMailer -------------------
        $mail = new PHPMailer(true);

        try {
            // SMTP settings (update with your server)
            $mail->isSMTP();
            $mail->Host       = 'mail.smartphonecity.ke';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'sales@smartphonecity.ke';
            $mail->Password   = 'njirainicanon.m';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port       = 587;

            $mail->setFrom('sales@smartphonecity.ke', 'W.Kirei');
            $mail->addAddress($order['email'], $order['username']);

            $mail->isHTML(true);
            $mail->Subject = 'Order Confirmation - '.$order['reference'];

          $itemsHtml = '';
            foreach($items as $item){
                $itemsHtml .= "<tr>
                    <td style='padding:12px 8px;border-bottom:1px solid #eee;'>{$item['product_name']} × {$item['product_qty']}</td>
                    <td style='padding:12px 8px;border-bottom:1px solid #eee;'>Ksh ".number_format($item['subtotal'],2)."</td>
                </tr>";
            }

            $mailBody = "
            <html>
            <head>
                <style>
                    body {
                        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                        background-color: #f4f6f8;
                        margin:0;
                        padding:0;
                        color:#333;
                    }
                    .container {
                        max-width: 650px;
                        margin: 40px auto;
                        background-color: #ffffff;
                        border-radius: 12px;
                        overflow: hidden;
                        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
                        border-top: 8px solid #007bff;
                    }
                    .header {
                        background-color: #007bff;
                        color: #fff;
                        padding: 20px;
                        text-align: center;
                    }
                    .header h2 {
                        margin:0;
                        font-size: 24px;
                    }
                    .content {
                        padding: 25px;
                    }
                    .content p {
                        font-size: 15px;
                        line-height: 1.6;
                        margin: 10px 0;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                        margin: 20px 0;
                        font-size: 15px;
                    }
                    th {
                        background-color: #007bff;
                        color: #fff;
                        padding: 12px;
                        text-align: left;
                    }
                    td {
                        padding: 12px;
                        border-bottom: 1px solid #eee;
                    }
                    tfoot td {
                        font-weight: bold;
                        font-size: 16px;
                    }
                    .footer {
                        background-color: #f4f6f8;
                        color: #777;
                        text-align: center;
                        font-size: 13px;
                        padding: 15px;
                        border-top: 1px solid #eee;
                    }
                    .btn-primary {
                        display: inline-block;
                        background-color: #007bff;
                        color: #fff;
                        text-decoration: none;
                        padding: 12px 25px;
                        border-radius: 6px;
                        margin-top: 15px;
                        font-weight: bold;
                    }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <h2>Thank you for your order!</h2>
                    </div>
                    <div class='content'>
                        <p>Hi <strong>{$order['username']}</strong>,</p>
                        <p>We have successfully received your payment. Here’s a summary of your order <strong>#{$order['reference']}</strong>:</p>

                        <table>
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                {$itemsHtml}
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>Total Amount</td>
                                    <td>Ksh ".number_format($order['total_amount'],2)."</td>
                                </tr>
                            </tfoot>
                        </table>

                        <p><strong>Shipping Address:</strong><br>
                        {$order['address']}</p>

                        <p>We will notify you once your order has been shipped.</p>

                        <a href='https://smartphonecity.ke/orders/{$order['reference']}' class='btn-primary'>View Your Order</a>
                    </div>

                    <div class='footer'>
                        &copy; ".date('Y')." W.Kirei. All rights reserved.<br>
                        Need help? <a href='mailto:support@smartphonecity.ke' style='color:#007bff; text-decoration:none;'>Contact Support</a>
                    </div>
                </div>
            </body>
            </html>
            ";


            $mail->Body = $mailBody;
            $mail->send();

        } catch (Exception $e) {
            error_log("Email sending failed: ".$mail->ErrorInfo);
        }

        // ✅ Return response after sending email
        echo json_encode(['status'=>'success','message'=>'Payment successful, order confirmed & email sent!']);

    } catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
    }

} else {
    echo json_encode(['status'=>'error','message'=>'Payment verification failed']);
}
?>
