<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);
include '../../inc/dbconn.php';
header('Content-Type: application/json');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid product ID']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM products WHERE product_id = ?");
    $stmt->execute([$_GET['id']]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($product) {
        // Load product description
        $descFile = '../../description/' . trim($product['product_desc']);
        $descText = file_exists($descFile)
            ? file_get_contents($descFile)
            : 'Product description not available.';

        // Split images (comma-separated filenames)
        $images = array_filter(array_map('trim', explode(',', $product['product_image'])));

        echo json_encode([
            'status' => 'success',
            'product' => [
                'id' => $product['product_id'],
                'title' => $product['product_title'],
                'slug' => $product['slug'],
                'price' => number_format($product['product_price']),
                'old_price' => $product['old_price'],
                'images' => $images,
                'description' => $product['product_short_description'],
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Product not found']);
    }
} catch (PDOException $e) {
    file_put_contents('../../logs/api_errors.log', date('Y-m-d H:i:s') . ' ' . $e->getMessage() . PHP_EOL, FILE_APPEND);
    echo json_encode(['status' => 'error', 'message' => 'Database error']);
}
