       <!-- footer start -->
        <footer id="footer">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="ft_newsletter">
                           <div id="block-newsletter-label" class="text-center my-4">
                                <div class="title-newsletter">
                                    <h2>Join Our Exclusive Newsletter</h2>
                                    <p class="desc">Subscribe today and get <strong>30% OFF</strong> your first order, plus exclusive updates and offers!</p>
                                </div>
                            </div>

                            <form id="newsletterForm" method="POST" class="newsletter-form position-relative d-flex justify-content-center align-items-center flex-wrap gap-2">
                                <div class="input-wrapper">
                                    <input name="email" id="newsletterEmail" class="form-control" placeholder="Enter your email address" type="email" required>
                                </div>
                                <button type="submit" class="btn btn-primary" id="subscribeBtn">
                                    <span class="btn-text">Subscribe</span>
                                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                </button>
                            </form>

                        </div>
                        <div class="pos_logo product_block_container">
                            <div class="logo-slider owl-carousel pos_content">
                                <?php
                                    try {
                                        $stmt = $pdo->prepare("SELECT * FROM partners ORDER BY created_at DESC");
                                        $stmt->execute();
                                        $partners = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                    } catch (PDOException $e) {
                                        die("Database error: " . $e->getMessage());
                                    }

                                    foreach ($partners as $partner):
                                        $logo_path = 'partner_logos/' . htmlspecialchars($partner['logo']);
                                        $name = htmlspecialchars($partner['name']);
                                        $website = !empty($partner['website_url']) ? htmlspecialchars($partner['website_url']) : '#';
                                    ?>
                                        <div class="item-banklogo">
                                            <a href="<?= $website ?>" target="_blank" title="<?= $name ?>">
                                                <img src="<?= $logo_path ?>" alt="<?= $name ?> brand logo" onerror="this.src='assets/images/brand/default.webp'" loading="lazy">
                                            </a>
                                        </div>
                                    <?php endforeach; ?>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- footer main -->
                <div class="footer-main">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6 col-lg-3 links footer_block">
                                <h3>Contact Info</h3>
                                <div class="footer-contact">
                                    <p class="address add">
                                        <?= htmlspecialchars($site_address); ?>
                                    </p>
                                    <p class="phone add">
                                        <?= htmlspecialchars($site_phone); ?>
                                    </p>
                                    <p class="email add">
                                        <a href="mailto:<?= htmlspecialchars($site_email); ?>">
                                            <?= htmlspecialchars($site_email); ?>
                                        </a>
                                    </p>
                                    <p class="time add">
                                        Working time: 9.00 - 21.00
                                    </p>
                                </div>

                                <div class="social_follow">
                                    <ul>
                                        <li class="facebook"><a href="#" target="_blank">Facebook</a></li>
                                        <li class="twitter"><a href="#" target="_blank">Twitter</a></li>
                                        <li class="youtube"><a href="#" target="_blank">YouTube</a></li>
                                        <li class="googleplus"><a href="#" target="_blank">Google +</a></li>
                                        <li class="instagram"><a href="#" target="_blank">Instagram</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-3 links footer_block">
                                <h3 class="hidden-sm-down">Shop</h3>
                                <ul class="footer_list">
                                    <li><a href="shop.php">All Products</a></li>
                                    <li><a href="shop.php">New Arrivals</a></li>
                                    <li><a href="shop.php">Best Sellers</a></li>
                                    <li><a href="shop.php">Special Offers</a></li>
                                    <li><a href="#account.php">My Account</a></li>
                                    <li><a href="contact.php">Contact Support</a></li>
                                </ul>
                            </div>

                            <div class="col-sm-6 col-lg-3 links footer_block">
                                <h3 class="hidden-sm-down">Our Company</h3>
                                <ul class="footer_list">
                                    <li><a href="about.php">About W.Kirei</a></li>
                                    <li><a href="#partners.php">Our Partners</a></li>
                                    <li><a href="blog.php">Beauty Journal</a></li>
                                    <li><a href="about.php">Shipping & Returns</a></li>
                                    <li><a href="about.php">Privacy Policy</a></li>
                                    <li><a href="about.php">Terms & Conditions</a></li>
                                </ul>
                            </div>



                            <div class="col-sm-6 col-lg-3 links footer_block">
                                <h3 class="hidden-sm-down">Instagram</h3>
                                <div class="container">
                                    <div class="row item-instagram">
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/1.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/2.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/3.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/4.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/5.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                        <div class="col-sm-4">
                                            <a href="#">
                                                <img src="assets/images/Instagram/6.webp" alt="harosa Instagram">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>                                
                        </div>
                    </div>
                </div>
                <!-- footer main end -->

            </div>

            <!-- footer copyright area -->
            <div class="footer-copyright-area">
                <div class="container">
                    <div class="copyright-inner">
                        <div class="row justify-content-between row-cols-1 row-cols-md-2">
                            <div class="col">
                                <p>
                                    &copy; <?php echo date('Y'); ?> 
                                    <span>W.Kirei</span> 
                                    Made with <i class="fa fa-heart text-danger"></i> by 
                                    <a href="<?php echo $author_url; ?>" target="_blank">
                                        <?php echo $site_author; ?>
                                    </a>
                                </p>
                            </div>

                            <div class="col text-md-end">
                                <img src="assets/images/icons/payment-icon.webp" alt="payment icon" loading="lazy">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- footer copyright area end -->

        </footer>
        <!-- footer end -->

        <!-- QUICKVIEW PRODUCT START -->
        <div id="quickview-wrapper">
            <!-- Modal -->
            <div class="modal fade" id="product_modal">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-close-btn">
                            <button class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <!-- single product area -->
                            <div class="single-product-page-area">
                                <div class="row">
                                    <!-- Product Images -->
                                    <div class="col-md-6">
                                        <div class="page-content">
                                            <div class="images-container">
                                                <div class="js-qv-mask mask pos_content">
                                                    <div class="product-images js-qv-product-images">
                                                        <div class="thumb-container">
                                                            <ul id="tabs1" class="nav nav-tabs" data-bs-tabs="tabs">
                                                                <li class="active"><a href="#img1" data-bs-toggle="tab"><img id="thumb1" src="assets/images/product/thumbnails/1.webp" alt=""></a></li>
                                                                <li><a href="#img2" data-bs-toggle="tab"><img id="thumb2" src="assets/images/product/thumbnails/2.webp" alt=""></a></li>
                                                                <li><a href="#img3" data-bs-toggle="tab"><img id="thumb3" src="assets/images/product/thumbnails/3.webp" alt=""></a></li>
                                                                <li><a href="#img4" data-bs-toggle="tab"><img id="thumb4" src="assets/images/product/thumbnails/4.webp" alt=""></a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="product-cover">
                                                    <div id="my-tab-content1" class="tab-content">
                                                        <div class="tab-pane fade show active" id="img1">
                                                            <img id="mainImage" src="assets/images/product/single/1.webp" alt="Product">
                                                            <div class="layer hidden-sm-down"><i class="material-icons zoom-in"></i></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Product Details -->
                                    <div class="col-md-6">
                                        <h1 class="h1 namne_details" id="productName">Product Name</h1>
                                        <p class="reference" id="productRef">Reference: demo_1</p>

                                        <div id="product_comments_block_extra" class="no-print">
                                            <div class="hook-reviews">
                                                <div class="comments_note">
                                                    <i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i>
                                                </div>
                                            </div>
                                            <ul class="comments_advices">
                                                <li><a href="#idTab5" class="reviews _mPS2id-h">Read reviews (<span>1</span>)</a></li>
                                                <li><a class="open-comment-form">Write a review</a></li>
                                            </ul>
                                        </div>

                                        <div class="product-prices">
                                            <div class="product-discount">
                                                <span class="regular-price" id="oldPrice">Ksh 0.00</span>
                                            </div>
                                            <div class="product-price h5 has-discount">
                                                <div class="current-price">
                                                    <span id="newPrice">Ksh 0.00</span>
                                                    <span class="discount discount-percentage" id="discountText"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="product-information">
                                            <div class="product-desc">
                                                <p><span id="productDesc">Description will appear here.</span></p>
                                            </div>

                                            <div class="product-actions">
                                                <form action="#">
                                                    <div class="product-discounts"></div>

                                                    <div class="product-add-to-cart">
                                                        <span class="control-label">Quantity</span>
                                                        <div class="box-quantity d-flex">
                                                            <input class="quantity mr-40" min="1" value="1" type="number">
                                                            <a class="add-cart" href="#" id="addToCartBtn"><i class="fa fa-shopping-cart"></i> add to cart</a>
                                                        </div>
                                                    </div>

                                                    <div class="product-additional-info">
                                                        <div class="social-sharing">
                                                            <span>Share</span>
                                                            <ul>
                                                                <li class="facebook"><a href="#" title="Share" target="_blank">Share</a></li>
                                                                <li class="twitter"><a href="#" title="Tweet" target="_blank">Tweet</a></li>
                                                                <li class="pinterest"><a href="#" title="Pinterest" target="_blank">Pinterest</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div> <!-- End Product Details -->
                                </div>
                            </div>
                            <!-- single product area -->
                        </div>
                    </div><!-- .modal-content -->
                </div><!-- .modal-dialog -->
            </div><!-- END Modal -->

        </div>
        <!-- QUICKVIEW PRODUCT END -->

    </div>
    <!-- Body main wrapper end -->
    




     <!-- JS
    ============================================ -->

    <!-- Modernizer & jQuery JS -->
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script>
    <!--<script src="assets/js/vendor/jquery-3.5.1.min.js"></script>-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/blueimp-md5/2.19.0/js/md5.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>

    <!-- Plugins JS -->
    <script src="assets/js/jquery.nivo.slider.pack.js"></script>
    <script src="assets/js/plugins.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>
    <script src="js/products/add_to_cart.js"></script>
    <script src="js/action/subscribe.js"></script>
    <script src="js/products/fetch_product.js"></script>
    
</body>

</html>