<?php
include_once 'dbconn.php';
?>
<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <!-- Primary Meta Tags -->
    <title>W.Kirei | Japanese Skincare Meets Kenyan Beauty</title>
    <meta name="description" content="W.Kirei brings authentic Japanese skincare to Kenya through our partnership with WITHOUT by FAITH Japan. Experience science-backed, gentle, and effective beauty care — now crafted for African skin.">

    <meta name="keywords" content="Japanese skincare Kenya, WITHOUT by FAITH, collagen serum, lamellar structure skincare, W.Kirei, beauty products Kenya, natural skincare, retinol serum Kenya, vitamin C serum, Japanese beauty brands">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.wkirei.co.ke/">

    <!-- Favicon and Manifest -->
    <link rel="icon" type="image/png" href="images/logo/w.kirei.png">
    <link rel="apple-touch-icon" href="images/logo/w.kirei.png">
    <link rel="manifest" href="manifest.json">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="W.Kirei | Japanese Skincare Meets Kenyan Beauty">
    <meta property="og:description" content="Discover authentic Japanese skincare now available in Kenya. W.Kirei combines science, simplicity, and natural balance for radiant, healthy skin.">
    <meta property="og:image" content="images/logo/w.kirei.png">
    <meta property="og:url" content="https://www.wkirei.co.ke/">
    <meta property="og:site_name" content="W.Kirei">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="W.Kirei | Japanese Skincare Meets Kenyan Beauty">
    <meta name="twitter:description" content="Experience Japanese innovation and African elegance with W.Kirei skincare. Pure, safe, and effective beauty solutions.">
    <meta name="twitter:image" content="images/logo/w.kirei.png">

    <!-- Geo & Language Metadata -->
    <meta name="geo.region" content="KE">
    <meta name="geo.placename" content="Nairobi">
    <meta name="language" content="en-KE">

    <!-- Theme & Mobile -->
    <meta name="theme-color" content="#f9f9f9">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">

    <!-- CSS: Core & Plugins -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/ionicons.min.css">
    <link rel="stylesheet" href="assets/css/css-plugins/animate.min.css">
    <link rel="stylesheet" href="assets/css/css-plugins/easyzoom.css">
    <link rel="stylesheet" href="assets/css/css-plugins/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/css-plugins/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/css-plugins/nice-select.css">
    <link rel="stylesheet" href="assets/css/css-plugins/nivo-slider.css">
    <link rel="stylesheet" href="assets/css/css-plugins/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/css/css-plugins/slick.css">
    <link rel="stylesheet" href="assets/css/css-plugins/slick-theme.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="assets/css/bundle.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="assets/css/colors.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
</head>

<body>
    <!-- Body main wrapper start -->
    <div class="wrapper home-one">

        <!-- HEADER AREA START -->
        <header class="header-area">

            <!-- Header top area start -->
            <div class="header-top-area d-none d-lg-block">
                <div class="container">
                    <div class="header-top-wrapper">
                        <div class="top-bar-left">
                            <div class="contact-link">
                                <div class="info_box phone">
                                    Call us : <span><?= $site_phone ?></span>
                                </div>
                                <div class="info_box email">
                                    email :  <a href="mailto:<?= $site_email ?>"><?= $site_email ?></a>
                                </div>
                            </div>
                            <div class="social_follow">
                                <ul>
                                    <li class="facebook"><a href="#"></a></li>
                                    <li class="twitter"><a href="#"></a></li>
                                    <li class="youtube"><a href="#"></a></li>
                                    <li class="googleplus"><a href="#"></a></li>
                                    <li class="instagram"><a href="#"></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="topbar-nav">
                            <!-- my account -->
                            <div class="dropdown menu-my-account-container">
                                <button data-bs-toggle="dropdown">
                                    <i class="first-icon fa fa-user-circle"></i> My Account <i class="ion-ios-arrow-down"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="login.php">My Account</a></li>
                                    <li><a href="checkout.php">Checkout</a></li>
                                    <li><a href="register.php">Sign in</a></li>
                                </ul>
                            </div>
                            <!-- currency-menu -->
                            <div class="dropdown currency">
                                <button data-bs-toggle="dropdown"> KES<i class="ion-ios-arrow-down"></i></button>
                                <ul class="dropdown-menu">
                                    <li><a href="#">$ USD</a></li>
                                    <li><a href="#">€ EUR</a></li>
                                </ul>
                            </div>
                            <!-- language-menu -->
                            <div class="dropdown language">
                                <button data-bs-toggle="dropdown">
                                    <img src="assets/images/icons/en.webp" alt="language-selector" loading="lazy">English
                                    <i class="ion-ios-arrow-down"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a href="#">
                                            <img src="assets/images/icons/en.webp" alt="French" loading="lazy">
                                            <span>English</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#">
                                            <img src="assets/images/icons/fr.webp" alt="French" loading="lazy">
                                            <span>French</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Top bar area end -->

            <!-- Header bottom area start -->
            <div class="header-bottom-area">
                <div class="container">
                    <div class="header-bottom-wrapper">

                        <div class="header-logo">
                            <a href="index.php">
                                <img src="images/logo/w.kirei.png" alt="<?= $site_name ?>" loading="lazy" style="width: 150px;height:auto;object-fit:cover;">
                            </a>
                        </div>

                        <!-- main-menu -->
                        <div class="main-menu d-none d-lg-block">
                            <nav>
                                <ul>
                                    <li class="current"><a href="index.php">Home </a>
                                    </li>
                                    <li><a href="shop.php">Shop</a></li>
                                    <li><a href="blog.php">Blog</a></li>
                                    <li><a href="about.php">About Us</a></li>
                                    <li><a href="contact.php">Contact</a></li>
                                </ul>
                            </nav>
                        </div>

                        <div class="header-bottom-action">
                            
                            <!-- Search -->
                            <div class="dropdown">
                                <button class="search-icon" data-bs-toggle="dropdown">
                                    <i class="fa fa-search"></i>
                                </button>
                                <div class="search_top dropdown-menu">
                                    <form method="get" action="#">
                                        <input class="text_input" name="s" value="" placeholder="Search" type="text">
                                        <button type="submit"><i class="fa fa-search"></i></button>
                                    </form>
                                </div>
                            </div>

                            <!-- Cart -->
                            <div class="dropdown">
                                <button class="cart-icon" data-bs-toggle="dropdown">
                                    <i class="fa fa-shopping-basket"></i>
                                    <span class="item_txt"> Cart</span> 
                                    <span class="item_count" id="cart-count">(0)</span>
                                    <span class="item_total" id="cart-total">- Ksh 0.00</span>
                                </button>

                                <div class="header-cart dropdown-menu" id="cart-dropdown">
                                    <!-- AJAX will populate this -->
                                    <div class="text-center p-3 text-muted">Cart is empty.</div>
                                </div>

                            </div>

                            <div class="header-action-toggle d-lg-none">
                                <button class="toggle" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- Header bottom area end -->

        </header>
        <!-- HRADER AREA END -->

        <!-- offcanvas Start -->
        <div class="offcanvas offcanvas-start" id="offcanvasMenu">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title">W.Kirei</h5>
                <button class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
            </div>
            <div class="offcanvas-body">
                
                <div class="contact-link">
                    <div class="info_box phone">
                        Call us : <span><?= $site_phone ?></span>
                    </div>
                    <div class="info_box email">
                        email :  <a href="mailto:<?= $site_email  ?>"><?= $site_email ?></a>
                    </div>
                </div>

                <div class="offcanvas-accordion accordion" id="accordionExample">
                    <div class="accordion-item">
                        <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseOne"><i class="first-icon fa fa-user-circle"></i> My Account</button>
                        <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <ul class="offcanvas-meta">
                                <li><a href="#login.php">My Account</a></li>
                                <li><a href="checkout.php">Checkout</a></li>
                                <li><a href="#register.php">Sign in</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseTwo">KES</button>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <ul class="offcanvas-meta">
                                <li><a href="#">$ USD</a></li>
                                <li><a href="#">€ EUR</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#collapseThree"><img src="assets/images/icons/en.webp" alt="language-selector">English</button>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <ul class="offcanvas-meta">
                                <li>
                                    <a href="#">
                                        <img src="assets/images/icons/en.webp" alt="French" loading="lazy">
                                        <span>English</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#">
                                        <img src="assets/images/icons/fr.webp" alt="French" loading="lazy">
                                        <span>French</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <nav class="canvas-menu">
                    <ul>
                        <li class="current"><a href="index.php">Home</a>
                        </li>
                        <li><a href="shop.php">Shop</a></li>
                        <li><a href="blog.php">Blog</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li><a href="contact.php">Contact</a></li>
                    </ul>
                </nav>

                <div class="social_follow">
                    <ul>
                        <li class="facebook"><a href="#"></a></li>
                        <li class="twitter"><a href="#"></a></li>
                        <li class="youtube"><a href="#"></a></li>
                        <li class="googleplus"><a href="#"></a></li>
                        <li class="instagram"><a href="#"></a></li>
                    </ul>
                </div>

            </div>
        </div>
        <!-- offcanvas END -->
