$(document).ready(function() {
    function fetchBlogs(page = 1) {
        $.ajax({
            url: 'api/action/fetch_blogs.php',
            type: 'GET',
            dataType: 'json',
            data: { page },
            success: function(response) {
                if (response.status === 'success') {
                    renderBlogs(response.blogs);
                    renderPagination(response.current_page, response.total_pages);

                    // ✅ Smooth scroll to the blog list top
                    $('html, body').animate({
                        scrollTop: $('#blog-list').offset().top - 100
                    }, 600);
                } else {
                    $('#blog-list').html('<p class="text-center text-danger">Failed to load blogs.</p>');
                    $('#pagination').empty();
                }
            },
            error: function(err) {
                console.error(err);
                $('#blog-list').html('<p class="text-center text-danger">Error loading blogs.</p>');
                $('#pagination').empty();
            }
        });
    }

    function renderBlogs(blogs) {
        let html = '';

        if (!blogs || blogs.length === 0) {
            $('#blog-list').html('<p class="text-center text-muted">No blogs available yet.</p>');
            return;
        }

        blogs.forEach(blog => {
            html += `
                <article class="text-center mb-5">
                    <div class="blog-entry-header">
                        <div class="post-category">
                            <a href="#">${(blog.tags || '').split(',')[0] || 'General'}</a>
                        </div>
                        <h1><a href="single-blog.php?slug=${blog.slug}">${blog.blog_title}</a></h1>
                        <div class="post-meta">
                            <a href="#" class="post-author"><i class="fa fa-user"></i> Posted by ${blog.author}</a>
                            <a href="#" class="post-date"><i class="fa fa-calendar"></i> ${new Date(blog.date).toDateString()}</a>
                        </div>
                    </div>

                    <div class="post-thumbnail">
                        <a href="single-blog.php?slug=${blog.slug}">
                            <img src="${blog.first_image}" alt="${blog.blog_title}">
                        </a>
                    </div>

                    <div class="postinfo-wrapper">
                        <p>${blog.content}</p>
                        <a class="readmore button" href="single-blog.php?slug=${blog.slug}">Read more</a>

                        <div class="social-sharing mt-3">
                            <h3>Share this post</h3>
                            <div class="social-sharie">
                                <ul class="social-icons">
                                    <li><a class="facebook social-icon" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(window.location.origin + '/single-blog.php?slug=' + blog.slug)}"><i class="fa fa-facebook"></i></a></li>
                                    <li><a class="twitter social-icon" target="_blank" href="https://twitter.com/intent/tweet?url=${encodeURIComponent(window.location.origin + '/single-blog.php?slug=' + blog.slug)}&text=${encodeURIComponent(blog.blog_title)}"><i class="fa fa-twitter"></i></a></li>
                                    <li><a class="linkedin social-icon" target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(window.location.origin + '/single-blog.php?slug=' + blog.slug)}"><i class="fa fa-linkedin"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </article>
            `;
        });

        $('#blog-list').html(html);
    }

    function renderPagination(current, total) {
        let html = '';

        if (total <= 1) {
            $('#pagination').empty();
            return;
        }

        if (current > 1) {
            html += `<a class="page-numbers" href="#" data-page="${current - 1}">Prev</a>`;
        }

        for (let i = 1; i <= total; i++) {
            if (i === 1 || i === total || (i >= current - 1 && i <= current + 1)) {
                html += `<a class="page-numbers ${i === current ? 'current' : ''}" href="#" data-page="${i}">${i}</a>`;
            } else if (i === current - 2 || i === current + 2) {
                html += `<span class="dots">...</span>`;
            }
        }

        if (current < total) {
            html += `<a class="page-numbers" href="#" data-page="${current + 1}">Next</a>`;
        }

        $('#pagination').html(html);
    }

    $('#pagination').on('click', '.page-numbers', function(e) {
        e.preventDefault();
        const page = $(this).data('page');
        if (page) fetchBlogs(page);
    });

    fetchBlogs(); // Load first page
});
