$(document).ready(function() {
    $('#commentForm').on('submit', function(e) {
        e.preventDefault();

        const form = $(this);
        const btn = $('#submit');
        const spinner = $('#spinner');
        const submitText = $('#submitText');
        const commentList = $('#commentList');

        // UI feedback
        btn.prop('disabled', true);
        spinner.removeClass('d-none');
        submitText.text('Submitting...');

        const formData = {
            post_id: $('#post_id').val(),
            name: $('#author').val(),
            email: $('#email').val(),
            message: $('#comment').val()
        };

        console.log("[COMMENT DEBUG] Sending form data:", formData);

        $.ajax({
            url: 'api/action/add_comment.php',
            type: 'POST',
            dataType: 'json',
            data: formData,
            success: function(response) {
                console.log("[COMMENT DEBUG] Response:", response);

                if (response.status === 'success') {
                    toastr.success(response.message);
                    form.trigger('reset');

                    // Generate avatar via Gravatar (md5 required)
                    const emailHash = md5(formData.email.trim().toLowerCase());
                    const avatarUrl = `https://www.gravatar.com/avatar/${emailHash}?d=identicon&s=100`;

                    // Create comment HTML instantly
                    const newCommentHTML = `
                        <li>
                            <div class="single-comment">
                                <div class="comment-avatar">
                                    <img src="${avatarUrl}" alt="avatar">
                                </div>
                                <div class="comment-info">
                                    <a href="#">${formData.name}</a>
                                    <span class="date">${new Date().toLocaleString()}</span>
                                    <p>${formData.message.replace(/\n/g, '<br>')}</p>
                                </div>
                            </div>
                        </li>
                    `;

                    // Append to top of list for immediate visibility
                    if (commentList.length > 0) {
                        commentList.prepend(newCommentHTML);
                    } else {
                        $('.comments-area ol.commentlist').html(`<ul id="commentList">${newCommentHTML}</ul>`);
                    }

                } else {
                    toastr.error(response.message || "Failed to submit comment.");
                }
            },
            error: function(xhr, status, error) {
                console.error("[COMMENT DEBUG] Error:", xhr.responseText || error);
                toastr.error("An unexpected error occurred.");
            },
            complete: function() {
                btn.prop('disabled', false);
                spinner.addClass('d-none');
                submitText.text('Post Comment');
            }
        });
    });
});


document.addEventListener("DOMContentLoaded", function() {
    const pageUrl = encodeURIComponent(window.location.href);
    const pageTitle = encodeURIComponent(document.title);

    // Update share links dynamically
    document.getElementById('share-facebook').href = `https://www.facebook.com/sharer/sharer.php?u=${pageUrl}`;
    document.getElementById('share-twitter').href = `https://twitter.com/intent/tweet?url=${pageUrl}&text=${pageTitle}`;
    document.getElementById('share-pinterest').href = `https://pinterest.com/pin/create/button/?url=${pageUrl}&description=${pageTitle}`;
    document.getElementById('share-linkedin').href = `https://www.linkedin.com/sharing/share-offsite/?url=${pageUrl}`;
    document.getElementById('share-email').href = `mailto:?subject=${pageTitle}&body=${pageUrl}`;
});