<?php
include_once 'inc/navigation.php';
?>

        <!-- top breadcrumb -->
         <?php
        if (!isset($_GET['slug']) || empty($_GET['slug'])) {
            echo "<p>Invalid product.</p>";
            exit;
        }

        $slug = $_GET['slug'];

        try {
            // Fetch product by slug
            $stmt = $pdo->prepare("
                SELECT 
                    product_id,
                    product_title,
                    product_price,
                    old_price,
                    product_image,
                    product_desc,
                    product_short_description
                FROM products
                WHERE slug = :slug AND product_status = 'on'
                LIMIT 1
            ");
            $stmt->execute(['slug' => $slug]);
            $product = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$product) {
                echo "<p>Product not found.</p>";
                exit;
            }

            // Handle images (in case multiple)
            $imageArray = array_map('trim', explode(',', $product['product_image']));
            $mainImage = !empty($imageArray[0]) ? 'product_images/' . $imageArray[0] : 'assets/images/default-product.webp';

            // Load description from file
            $descFile = 'description/' . basename($product['product_desc']);
            $description = (is_file($descFile) && file_exists($descFile)) 
                ? file_get_contents($descFile) 
                : '';

        } catch (PDOException $e) {
            echo "<p>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
            exit;
        }
        ?>
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span><?= htmlspecialchars($product['product_title']) ?></span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- single product area -->
        <div class="single-product-page-area">
            <div class="container">
                

                <!-- ✅ Product Display -->
                <div class="row gy-5">
                    <div class="col-lg-6">
                        <div class="images-container">
                            <div class="js-qv-mask mask pos_content">
                                <div class="thumb-container">
                                    <ul class="nav nav-tabs">
                                        <?php foreach ($imageArray as $i => $img): ?>
                                            <li class="nav-item">
                                                <a class="nav-link <?= $i === 0 ? 'active' : '' ?>" 
                                                id="tab<?= $i ?>" 
                                                data-bs-toggle="tab" 
                                                href="#img<?= $i ?>" 
                                                role="tab">
                                                    <img src="product_images/<?= htmlspecialchars($img) ?>" alt="<?= htmlspecialchars($product['product_title']) ?>">
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="product-cover">
                                <div class="tab-content">
                                    <?php foreach ($imageArray as $i => $img): ?>
                                        <div class="tab-pane fade <?= $i === 0 ? 'show active' : '' ?>" 
                                            id="img<?= $i ?>" 
                                            role="tabpanel">
                                            <img src="product_images/<?= htmlspecialchars($img) ?>" alt="<?= htmlspecialchars($product['product_title']) ?>">
                                            <div class="layer hidden-sm-down">
                                                <i class="material-icons zoom-in"></i>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="col-lg-6">
                        <h1 class="h1 namne_details"><?= htmlspecialchars($product['product_title']) ?></h1>
                        <p class="reference">Reference: <?= $product['product_id'] ?></p>

                        <div class="product-prices">
                            <?php if (!empty($product['old_price']) && $product['old_price'] > 0): ?>
                                <div class="product-discount">
                                    <span class="regular-price">Ksh <?= number_format($product['old_price'], 2) ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="product-price h5 has-discount">
                                <div class="current-price">
                                    <span>Ksh <?= number_format($product['product_price'], 2) ?></span>
                                    <?php if (!empty($product['old_price']) && $product['old_price'] > 0): 
                                        $discount = round((($product['old_price'] - $product['product_price']) / $product['old_price']) * 100);
                                    ?>
                                        <span class="discount discount-percentage">Save <?= $discount ?>%</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="product-information">
                            <div class="product-desc">
                                <p><?= $product['product_short_description'] ?></p>
                            </div>
                            <div class="product-actions">
                                <form action="#">
                                    <div class="product-add-to-cart">
                                        <div class="box-quantity d-flex flex-wrap align-items-center gap-2">
                                            <!-- Add to Cart button -->
                                            <a class="add-cart btn btn-primary d-flex align-items-center justify-content-center flex-nowrap add-to-cart-btn" 
                                            href="#" data-id="<?= $product['product_id'] ?>">
                                                <i class="fa fa-shopping-cart me-1"></i> 
                                                <span class="btn-text">Add to cart</span>
                                            </a>

                                            <?php
                                            // WhatsApp quick checkout
                                            $productTitle = urlencode($product['product_title']);
                                            $productPrice = number_format($product['product_price'], 2);
                                            $currentUrl = urlencode((isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
                                            $whatsappMessage = "Hello! I'm interested in buying *$productTitle* priced at Ksh $productPrice. Check it here: $currentUrl";
                                            $whatsappUrl = "https://wa.me/254741575274?text=$whatsappMessage";
                                            ?>

                                            <!-- WhatsApp button -->
                                            <a href="<?= $whatsappUrl ?>" target="_blank" 
                                            class="btn btn-whatsapp d-flex align-items-center justify-content-center flex-nowrap">
                                                <i class="fa fa-whatsapp me-1"></i> 
                                                <span class="btn-text">Quick Checkout</span>
                                            </a>
                                        </div>


                                        <style>
                                        /* Permanent WhatsApp green color */
                                        .btn-whatsapp {
                                            background-color: #25D366 !important;
                                            border-color: #25D366 !important;
                                            color: #fff !important;
                                        }

                                        .btn-whatsapp:hover,
                                        .btn-whatsapp:focus,
                                        .btn-whatsapp:active {
                                            background-color: #25D366 !important;
                                            border-color: #25D366 !important;
                                            color: #fff !important;
                                            text-decoration: none;
                                        }
                                        </style>

                                    </div>
                                    <div class="product-additional-info">
                                        <div class="social-sharing">
                                            <span>Share</span>
                                            <ul>
                                                <li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']) ?>" target="_blank">Share</a></li>
                                                <li class="twitter"><a href="https://twitter.com/intent/tweet?url=<?= urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']) ?>" target="_blank">Tweet</a></li>
                                                <li class="pinterest"><a href="https://pinterest.com/pin/create/button/?url=<?= urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']) ?>" target="_blank">Pinterest</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- single product area -->

        <!-- product tabs container slider -->
        <div class="single-product-description-area product-tabs-container-slider product_block_container">
            <div class="container">
                <?php
                echo '
                <ul class="nav tabs_slider mb-4" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active fw-semibold" id="description-tab" data-bs-toggle="tab" data-bs-target="#newarrival" type="button" role="tab" aria-controls="newarrival" aria-selected="true">
                            Description
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link fw-semibold" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#featuredproducts" type="button" role="tab" aria-controls="featuredproducts" aria-selected="false">
                            Reviews
                        </button>
                    </li>
                </ul>

                <div class="tab-content pos_content">';

                // ✅ Description Tab
                echo '
                <div class="tab-pane fade show active" id="newarrival" role="tabpanel" aria-labelledby="description-tab">
                    <p class="text-muted lh-lg fs-6">' . nl2br($description) . '</p>
                </div>';

                // ✅ Reviews Tab
                echo '
                <div class="tab-pane fade" id="featuredproducts" role="tabpanel" aria-labelledby="reviews-tab">
                    <div id="product_comments_block_tab" class="mt-3 text-start">
                ';

                $reviewsStmt = $pdo->prepare("SELECT * FROM reviews WHERE product_id = :pid ORDER BY date DESC");
                $reviewsStmt->execute(['pid' => $product['product_id']]);
                $reviews = $reviewsStmt->fetchAll(PDO::FETCH_ASSOC);

                if ($reviews) {
                    foreach ($reviews as $r) {
                        echo '
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <h6 class="mb-0 fw-bold">' . htmlspecialchars($r['name']) . '</h6>
                                        <small class="text-muted">' . date('F d, Y', strtotime($r['date'])) . '</small>
                                    </div>
                                    <div class="text-warning">';
                                        for ($i = 1; $i <= 5; $i++) {
                                            echo $i <= $r['rating'] ? '<i class="fa fa-star"></i>' : '<i class="fa fa-star-o"></i>';
                                        }
                        echo '      </div>
                                </div>
                                <p class="mb-0 text-secondary">' . nl2br(htmlspecialchars($r['comment'])) . '</p>
                            </div>
                        </div>';
                    }
                } else {
                    echo '<p class="text-muted mt-3">No reviews yet. Be the first to write one!</p>';
                }

                // ✅ Review Form
                ?>
                    <div class="text-center mt-4">
                        <button class="btn btn-outline-primary px-4" data-bs-toggle="collapse" data-bs-target="#reviewForm" aria-expanded="false" aria-controls="reviewForm">
                            <i class="fa fa-pencil me-2"></i>Write a Review
                        </button>
                    </div>

                    <div id="reviewForm" class="collapse mt-4">
                        <form method="POST" action="api/reviews/add_review.php" class="p-4 border rounded bg-light shadow-sm">
                            <input type="hidden" name="product_id" value="<?= $product['product_id'] ?>">

                            <div class="mb-3">
                                <label for="name" class="form-label fw-semibold">Your Name</label>
                                <input type="text" name="name" id="name" class="form-control" required>
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label fw-semibold">Your Email</label>
                                <input type="email" name="email" id="email" class="form-control" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-semibold d-block mb-2">Rating</label>
                                <div class="star-rating" style="font-size:1.5rem; color:#ffc107; cursor:pointer;">
                                    <?php for ($i = 5; $i >= 1; $i--): ?>
                                        <input type="radio" name="rating" id="star<?= $i ?>" value="<?= $i ?>" style="display:none;">
                                        <label for="star<?= $i ?>" class="star-label">★</label>
                                    <?php endfor; ?>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="comment" class="form-label fw-semibold">Your Review</label>
                                <textarea name="comment" id="comment" rows="4" class="form-control" placeholder="Write your experience..." required></textarea>
                            </div>

                            <button type="submit" class="btn btn-primary px-4 mt-2">Submit Review</button>
                        </form>
                    </div>
                <?php
                echo '</div></div></div>'; // close all
                ?>
                <style>
                    .tabs_slider .nav-link {
                    border: none;
                    color: #555;
                    padding: 10px 20px;
                    transition: all 0.3s ease;
                    }
                    .tabs_slider .nav-link.active {
                    color: #fff;
                    background-color: #000;
                    border-radius: 4px;
                    }
                    .star-rating label:hover,
                    .star-rating label:hover ~ label {
                    color: #ff9800 !important;
                    }

                </style>
            </div>
        </div>
        <!-- product tabs container slider end -->

        <!-- product tabs container slider -->
        <div class="single-product-related-post product-tabs-container-slider product_block_container">
            <div class="container">
                <ul class="nav tabs_slider">
                    <li class="active text-decoration-none"><a href="#newarrival" data-bs-toggle="tab"> Related Products</a></li>
                </ul>
                <div class="tab-content pos_content">
                    <div class="tab-pane active" id="newarrival">
                        <div class="productTabContent0 owl-carousel">
                            <!-- single product -->
                           <?php
                            if (!isset($_GET['slug'])) {
                                echo '<p class="text-danger">No product specified.</p>';
                                exit;
                            }

                            $current_slug = $_GET['slug'];

                            try {
                                // 1️⃣ Get the current product
                                $stmt = $pdo->prepare("SELECT * FROM products WHERE slug = :slug AND product_status = 'on' LIMIT 1");
                                $stmt->execute(['slug' => $current_slug]);
                                $currentProduct = $stmt->fetch(PDO::FETCH_ASSOC);

                                if (!$currentProduct) {
                                    echo '<p class="text-danger">Product not found.</p>';
                                    exit;
                                }

                                $current_cat = $currentProduct['product_cat'];

                                // 2️⃣ Fetch 20 other products from the same category
                                $stmt = $pdo->prepare("
                                    SELECT p.*, c.cat_title
                                    FROM products p
                                    LEFT JOIN categories c ON p.product_cat = c.cat_id
                                    WHERE p.product_status = 'on' 
                                    AND p.product_cat = :cat 
                                    AND p.slug != :slug
                                    ORDER BY RAND() 
                                    LIMIT 20
                                ");
                                $stmt->execute(['cat' => $current_cat, 'slug' => $current_slug]);
                                $similarProducts = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                if ($similarProducts) {
                                    foreach ($similarProducts as $p) {
                                        $images = explode(',', $p['product_image']);
                                        $image = !empty($images[0]) ? 'product_images/' . trim($images[0]) : 'assets/images/default-product.webp';
                                        $productUrl = 'product.php?slug=' . urlencode($p['slug']);

                                        // optional: calculate discount
                                        $discount = ($p['old_price'] > 0 && $p['old_price'] > $p['product_price'])
                                            ? round(100 - ($p['product_price'] / $p['old_price'] * 100)) . '%'
                                            : '';

                                        echo '
                                        <div class="item-product">
                                            <div class="product-miniature js-product-miniature">
                                                <div class="img_block">
                                                    <a href="'. htmlspecialchars($productUrl) .'" class="thumbnail product-thumbnail">
                                                        <img src="'. htmlspecialchars($image) .'" alt="'. htmlspecialchars($p['product_title']) .'">
                                                    </a>';

                                        if ($discount) {
                                            echo '<div class="product-price-and-shipping_top">
                                                    <span class="discount-percentage discount-product">-' . $discount . '</span>
                                                </div>';
                                        }

                                        echo '  <div class="hook-reviews">
                                                    <div class="comments_note">';
                                        for ($i=1; $i<=5; $i++) {
                                            echo '<i class="fa fa-star"></i>'; // replace with dynamic rating if available
                                        }
                                        echo '    </div>
                                                </div>
                                                <div class="quick-view">
                                                    <a href="#" data-bs-toggle="modal" data-bs-target="#product_modal" data-original-title="Quick View" class="quick_view">
                                                        <i class="fa fa-search"></i>
                                                    </a>
                                                </div>
                                                </div>
                                                <div class="product_desc">
                                                    <div class="manufacturer">
                                                        <a href="category/'. urlencode($p['cat_title']) .'">'. htmlspecialchars($p['cat_title']) .'</a>
                                                    </div>
                                                    <h1>
                                                        <a href="'. htmlspecialchars($productUrl) .'" class="product_name" title="'. htmlspecialchars($p['product_title']) .'">
                                                            '. htmlspecialchars($p['product_title']) .'
                                                        </a>
                                                    </h1>
                                                    <div class="product-price-and-shipping">
                                                       <!-- <span class="regular-price">'. number_format($p['old_price'], 2) .'</span>-->
                                                        <span class="price price-sale">'. number_format($p['product_price'], 2) .'</span>
                                                    </div>
                                                    <div class="cart">
                                                        <div class="product-add-to-cart">
                                                            <a href="#" class="add-to-cart-btn" data-id="'. $p['product_id'] .'">
                                                                <span class="btn-text">Add to cart</span>
                                                                <span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>';
                                    }
                                } else {
                                    echo '<p class="text-muted">No similar products found.</p>';
                                }

                            } catch (PDOException $e) {
                                echo '<p class="text-danger">Database error: ' . $e->getMessage() . '</p>';
                            }
                            ?>



                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- product tabs container slider end -->
<?php
include_once 'inc/footer.php';
?>
<script>
    // Highlight stars on hover & click
$(document).ready(function() {
    // Set stars on hover
    $('.star-rating .star-label').hover(function() {
        const val = parseInt($(this).prev('input').val()); // get the value of the radio before the label
        $('.star-rating .star-label').each(function() {
            const starVal = parseInt($(this).prev('input').val());
            $(this).toggleClass('text-warning', starVal <= val);
        });
    }, function() {
        // Reset based on checked
        const rating = parseInt($('input[name="rating"]:checked').val()) || 0;
        $('.star-rating .star-label').each(function() {
            const starVal = parseInt($(this).prev('input').val());
            $(this).toggleClass('text-warning', starVal <= rating);
        });
    });

    // Click selects rating
    $('.star-rating .star-label').click(function() {
        const val = parseInt($(this).prev('input').val());
        $('input[name="rating"][value="'+val+'"]').prop('checked', true);

        // Update star highlight immediately
        $('.star-rating .star-label').each(function() {
            const starVal = parseInt($(this).prev('input').val());
            $(this).toggleClass('text-warning', starVal <= val);
        });
    });
});


$(document).on('submit', '#reviewForm form', function(e) {
    e.preventDefault();
    const form = $(this);

    const ratingVal = form.find('input[name="rating"]:checked').val();
    if (!ratingVal) {
        toastr.error('Please select a rating before submitting.');
        return;
    }

    $.ajax({
        url: form.attr('action'),
        type: 'POST',
        data: form.serialize(),
        dataType: 'json',
        success: function(res) {
            if (res.status === 'success') {
                toastr.success(res.message);

                // Reset form and hide collapse
                form.trigger('reset');
                $('#reviewForm').collapse('hide');

                // If new review data is returned
                if (res.review) {
                    const r = res.review;
                    const stars = Array.from({length: 5}, (_, i) => 
                        i < r.rating 
                            ? '<i class="fa fa-star text-warning"></i>'
                            : '<i class="fa fa-star-o text-warning"></i>'
                    ).join('');

                    const newReview = `
                        <div class="card border-0 shadow-sm mb-4 review-card" style="display:none;">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <h6 class="mb-0 fw-bold">${$('<div>').text(r.name).html()}</h6>
                                        <small class="text-muted">${r.date}</small>
                                    </div>
                                    <div>${stars}</div>
                                </div>
                                <p class="mb-0 text-secondary">${$('<div>').text(r.comment).html().replace(/\n/g, '<br>')}</p>
                            </div>
                        </div>
                    `;

                    // Insert at the top of the reviews section
                    $('#product_comments_block_tab').prepend(newReview);
                    $('.review-card:first').slideDown(400);
                }

            } else {
                toastr.error(res.message);
            }
        },
        error: function() {
            toastr.error('Something went wrong.');
        }
    });
});
</script>

