<?php
include_once 'inc/navigation.php';
?>
        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li><a href="index.php"><span>Home</span></a></li>
                            </li>
                            <li><a href="#"><span>Shop</span></a></li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- Shop page wraper -->
        <div class="shop-page-wraper">
            <div class="container">
                <div class="row flex-row-reverse">
                    <div class="col-lg-9 shop-content">
                        <div class="product-toolbar">
                            <div class="topbar-title">
                                <h1 id="page-title">All Products</h1>
                            </div>
                            <div class="product-toolbar-inner">
                                <div class="woocommerce-ordering">
                                    <div class="orderby-wrapper">
                                        <label>Sort By :</label>
                                        <select class="nice-select-menu orderby" id="sort_by">
                                            <option value="">Default sorting</option>
                                            <option value="price_asc">Price: Low to High</option>
                                            <option value="price_desc">Price: High to Low</option>
                                            <option value="newest">Newest First</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- PRODUCT GRID -->
                        <div class="shop-page-product-area tab-content">
                            <div id="grid" class="tab-pane fade show active">
                                <div class="row" id="product-container">
                                    <!-- Products loaded here via AJAX -->
                                </div>
                            </div>
                        </div>

                        <!-- PAGINATION -->
                        <nav class="woocommerce-pagination">
                            <ul class="page-numbers" id="pagination">
                                <!-- pagination links injected dynamically -->
                            </ul>
                        </nav>
                    </div>
                    <div class="col-lg-3 sidebar-shop">
                        <div class="sidebar-product-categori">
                            <div class="shop-categori-title">
                                <h3>Skincare & Beauty</h3>
                            </div>

                            <div class="product-filter mb-30">
                                <div class="widget-title">
                                    <h3>Filter by price</h3>
                                </div>
                                <div class="widget-content">
                                    <div id="price-range"></div>
                                    <div class="price-values">
                                        <div class="price_text_btn">
                                            <span>Price:</span>
                                            <input type="text" class="price-amount">
                                        </div>
                                        <button class="button" type="submit">Filter</button>
                                    </div>
                                </div>
                            </div>

                            <div class="advertising">
                                <a href="shop.php"><img src="images/new_images/side_banner.webp" alt="<?= $site_name ?>" loading="lazy"></a>
                            </div>
                            <div class="shop-categori-page categori-mini-product-area">
                                <div class="pos-featured-products  product_block_container">
                                    <div class="pos_title"><h2>New products</h2></div>
                                </div>
                                <div class=" pos_content row">
                                    <div class="feature-item owl-carousel">
                                        <div class="item-product" id="mini-products-container">
                                            <!-- Mini Products Section -->
                                            <?php
                                            try {
                                                // Fetch 3 random active products
                                                $stmt = $pdo->prepare("
                                                    SELECT 
                                                        product_id, 
                                                        product_title, 
                                                        slug, 
                                                        product_price, 
                                                        old_price, 
                                                        product_image 
                                                    FROM products 
                                                    WHERE product_status = 'on'
                                                    ORDER BY RAND() 
                                                    LIMIT 3
                                                ");
                                                $stmt->execute();
                                                $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                                if ($products):
                                                    foreach ($products as $p):
                                                        // Handle images (in case multiple images are stored)
                                                        $imageArray = explode(',', $p['product_image']);
                                                        $image = !empty(trim($imageArray[0])) 
                                                            ? 'product_images/' . trim($imageArray[0]) 
                                                            : 'assets/images/default-product.webp';

                                                        // Fallback URL if slug missing
                                                        $productUrl = !empty($p['slug']) 
                                                            ? 'product/' . htmlspecialchars($p['slug']) 
                                                            : 'product.php?id=' . (int)$p['product_id'];
                                            ?>
                                                        <div class="product-miniature js-product-miniature">
                                                            <div class="img_block">
                                                                <a href="<?= $productUrl ?>" class="thumbnail product-thumbnail">
                                                                    <img src="<?= htmlspecialchars($image) ?>" alt="<?= htmlspecialchars($p['product_title']) ?>">
                                                                </a>
                                                            </div>
                                                            <div class="product_desc">
                                                                <div class="manufacturer">
                                                                    <a href="#">W.Kirei</a>
                                                                </div>
                                                                <h1>
                                                                    <a href="<?= $productUrl ?>"><?= htmlspecialchars($p['product_title']) ?></a>
                                                                </h1>
                                                                <div class="product-price-and-shipping">
                                                                    <span class="price">Ksh <?= number_format($p['product_price'], 2) ?></span>
                                                                    <?php if (!empty($p['old_price']) && $p['old_price'] > 0): ?>
                                                                        <span class="old-price text-muted ms-2">
                                                                            <del>Ksh <?= number_format($p['old_price'], 2) ?></del>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                            <?php
                                                    endforeach;
                                                else:
                                                    echo '<p>No products found.</p>';
                                                endif;
                                            } catch (PDOException $e) {
                                                echo '<p class="text-danger">Database error: ' . htmlspecialchars($e->getMessage()) . '</p>';
                                            }
                                            ?>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
        </div>
        <!-- Shop page wraper end -->

<?php
include_once 'inc/footer.php';
?>

<script>
let currentPage = 1;
let category = "<?php echo $_GET['cat'] ?? ''; ?>";
let brand = "<?php echo $_GET['brand'] ?? ''; ?>";
let search = "<?php echo $_GET['q'] ?? ''; ?>";

function loadProducts(page = 1) {
    $.ajax({
        url: "api/products/fetch_shop_products.php",
        type: "GET",
        data: {
            page: page,
            category: category,
            brand: brand,
            search: search,
            sort: $("#sort_by").val()
        },
        beforeSend: function() {
            $("#product-container").html('<div class="text-center w-100 p-4">Loading...</div>');
        },
        success: function(response) {
            $("#product-container").html(response.products);
            $("#pagination").html(response.pagination);
            $("html, body").animate({ scrollTop: $("#grid").offset().top - 100 }, "slow");
            currentPage = page;
        }
    });
}

// handle sorting
$("#sort_by").change(function() {
    loadProducts(1);
});

// pagination click
$(document).on("click", ".page-link", function(e) {
    e.preventDefault();
    let page = $(this).data("page");
    if (page) loadProducts(page);
});

$(document).ready(function() {
    loadProducts();
});




</script>