<?php
include_once "inc/dbconn.php";
date_default_timezone_set('Africa/Nairobi');

// Validate session
if (!isset($_SESSION['uid'])) {
    echo "<script>alert('User not logged in'); location.href='login.php';</script>";
    exit;
}

$userid = $_SESSION['uid'];

$blog_title = trim($_POST['blog_title']);
$publish_status = isset($_POST['publish_status']) ? '1' : '0';
$meta_title = trim($_POST['meta_title']);
$meta_description = trim($_POST['meta_description']);
$blog = trim($_POST['blog']);
$author = trim($_POST['author']);
$category_id = trim($_POST['category_id']);

// Generate slug
$slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $blog_title)));

if (empty($blog_title)) {
    echo "<script>alert('Title should not be empty'); location.href='blog.php';</script>";
    exit;
}

$get_name = $connection->query("SELECT * FROM blog WHERE slug = '$slug'");
if (mysqli_num_rows($get_name) > 0) {
    echo "<script>alert('A blog with that title already exists. Please try a unique title.'); location.href='blog.php';</script>";
    exit;
}

if (empty($blog)) {
    echo "<script>alert('Blog content cannot be empty.'); location.href='blog.php';</script>";
    exit;
}

// Write blog content to file
$title2 = substr(preg_replace('/[^A-Za-z0-9]/', '', $blog_title), 0, 6);
$filename = $title2 . "@" . uniqid("veenblog", true) . ".txt";
$blogPath = "../blog/" . $filename;

if (file_put_contents($blogPath, $blog) === false) {
    echo "<script>alert('Failed to write blog content to file.'); location.href='blog.php';</script>";
    exit;
}

// Write meta description to file
$meta_name = $title2 . "@" . uniqid("_veenmeta", true) . ".txt";
$metaPath = "../metadesc/" . $meta_name;

if (file_put_contents($metaPath, $meta_description) === false) {
    echo "<script>alert('Failed to write meta description.'); location.href='blog.php';</script>";
    exit;
}

// Process images
$all_files = glob("uploads/{$userid}/*.{jpg,jpeg,png,gif,jfif,webp}", GLOB_BRACE);
$targetDir = "../blog_images/";
$insertValuesSQL = '';

if (!empty($all_files)) {
    foreach ($all_files as $image_path) {
        $imageRealName = basename($image_path);
        $ext = strtolower(pathinfo($imageRealName, PATHINFO_EXTENSION));
        $supported_format = ['jpg', 'jpeg', 'png', 'gif', 'jfif', 'webp'];

        if (in_array($ext, $supported_format)) {
            $fileName = $title2 . "_veen_" . uniqid(true) . "." . $ext;
            $targetFilePath = $targetDir . $fileName;

            if (rename($image_path, $targetFilePath)) {
                $insertValuesSQL .= $fileName . ",";
            } else {
                file_put_contents("image_errors.log", "Failed to move $image_path\n", FILE_APPEND);
            }
        } else {
            file_put_contents("image_errors.log", "Unsupported file type: $image_path\n", FILE_APPEND);
        }
    }
}

$insertValuesSQL = rtrim($insertValuesSQL, ',');

// Insert into DB
$stmt = $connection->prepare("INSERT INTO blog (blog_title, slug, blog, blog_image, publish_status, meta_title, meta_description, author, category_id) VALUES (?, ?, ?, ?, ?, ?, ?,?,?)");
$stmt->bind_param("ssssisssi", $blog_title, $slug, $filename, $insertValuesSQL, $publish_status, $meta_title, $meta_name, $author, $category_id);

if ($stmt->execute()) {
    $update = $connection -> query("UPDATE blog SET blog_image = '$insertValuesSQL' WHERE slug = '$slug'");

    echo "<script>alert('Blog Added Successfully'); location.href='blog.php';</script>";
} else {
    file_put_contents("db_errors.log", "DB Error: " . $stmt->error . "\n", FILE_APPEND);
    echo "<script>alert('Failed to save blog.'); location.href='blog.php';</script>";
}
?>
