<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>
<?php


?>
<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Product Edit Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li>
                <a href="page_ecom_dashboard.php"><i class="fa fa-bar-chart"></i> Dashboard</a>
            </li>
            <li>
                <a href="page_ecom_orders.php"><i class="gi gi-shop_window"></i> Orders</a>
            </li>
            <li>
                <a href="page_ecom_order_view.php"><i class="gi gi-shopping_cart"></i> Order View</a>
            </li>
            <li>
                <a href="page_ecom_products.php"><i class="gi gi-shopping_bag"></i> Products</a>
            </li>
            <li>
                <a href="blog.php"><i class="gi gi-shopping_bag"></i> Blog</a>
            </li>
            <li class="active">
                <a href="courses.php" ><i class="gi gi-user"></i> Courses</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Product Edit Header -->

    <!-- Product Edit Content -->
    <div class="row">
        <div class="col-lg-6">
            <!-- General Data Block -->
            <div class="block">
                <!-- General Data Title -->
                <div class="block-title">
                    <h2><i class="fa fa-pencil"></i> <strong>General</strong> Data</h2>
                </div>
                <!-- END General Data Title -->

                <!-- General Data Content -->
                <?php
                if(!empty($_GET['pid'])) {
                    $pid = $_GET['pid'];
                   
                }
                ?>
                <form action="add_package.php" method="post" class="form-horizontal form-bordered" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-6">
                            <!-- Sponsorship Package Data Block -->
                            <div class="block">
                                <div class="block-title">
                                    <h2><i class="fa fa-gift"></i> <strong>Add</strong> Sponsorship Package</h2>
                                </div>

                                <!-- Form Fields -->
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="sponsorship_title">Title</label>
                                    <div class="col-md-9">
                                        <input type="text" name="sponsorship_title" class="form-control" placeholder="e.g. Principal Sponsor" required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="slug">Slug</label>
                                    <div class="col-md-9">
                                        <input type="text" name="slug" class="form-control" placeholder="e.g. principal-sponsor" required>
                                        <div class="help-block">Used in URLs. Must be unique.</div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="sponsorship_tier">Tier</label>
                                    <div class="col-md-9">
                                        <select name="sponsorship_tier" class="form-control" required>
                                            <option value="">-- Select Tier --</option>
                                            <option value="Principal">Principal</option>
                                            <option value="Major">Major</option>
                                            <option value="Supporting">Supporting</option>
                                            <option value="A La Carte">A La Carte</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Price (KES)</label>
                                    <div class="col-md-9">
                                        <input type="number" name="price_kes" class="form-control" placeholder="e.g. 12950000" required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Price (USD)</label>
                                    <div class="col-md-9">
                                        <input type="number" name="price_usd" class="form-control" placeholder="e.g. 100000">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="benefits">Benefits</label>
                                    <div class="col-md-9">
                                        <textarea name="benefits" class="ckeditor" rows="6" placeholder="List the benefits or features for this sponsorship package"></textarea>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Button Label</label>
                                    <div class="col-md-9">
                                        <input type="text" name="btn_label" class="form-control" placeholder="e.g. Become a Sponsor" value="Become a Sponsor">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Image</label>
                                    <div class="col-md-9">
                                        <input type="file" name="image" class="form-control">
                                        <div class="help-block">Recommended size: 800x500px (JPG or PNG)</div>
                                    </div>
                                </div>

                                <div class="form-group form-actions">
                                    <div class="col-md-9 col-md-offset-3">
                                        <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-floppy-o"></i> Save</button>
                                        <button type="reset" class="btn btn-sm btn-warning"><i class="fa fa-repeat"></i> Reset</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Meta Data Column -->
                        <div class="col-lg-6">
                            <div class="block">
                                <div class="block-title">
                                    <h2><i class="fa fa-info-circle"></i> <strong>Meta</strong> Data</h2>
                                </div>

                                <div class="form-horizontal form-bordered">
                                    <div class="form-group">
                                        <label class="col-md-3 control-label" for="meta_title">Meta Title</label>
                                        <div class="col-md-9">
                                            <input type="text" id="meta_title" name="meta_title" class="form-control" placeholder="Enter meta title...">
                                            <div class="help-block"> <span id="count_c">0</span> / 60 Characters Max</div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-md-3 control-label" for="meta_description">Meta Description</label>
                                        <div class="col-md-9">
                                            <textarea name="meta_description" id="meta_desc" class="form-control" rows="6" placeholder="Enter meta description..."></textarea>
                                            <div class="help-block"><span id="count_d">0</span> / 150 Characters Max</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- /.row -->
                </form>

            <!-- END Meta Data Block -->

            <!-- Product Images Block -->
            <div class="block">
                <!-- Product Images Title -->
                <div class="block-title">
                    <h2><i class="fa fa-picture-o"></i> <strong>Course</strong> Image</h2>
                </div>
                <!-- END Product Images Title -->

                <!-- Product Images Content -->
                <div class="block-section">
                    <!-- Dropzone.js, You can check out https://github.com/enyo/dropzone/wiki for usage examples -->
                    <form action="process_image.php" class="dropzone"></form>
                </div>
                <table id="load_images" class="table table-bordered table-striped table-vcenter">
                    <tbody >
                        <?php
                            $all_files = glob("uploads/".$user_id."/*.*");
                            for ($i=0; $i<count($all_files); $i++)
                            {
                                $image_name = $all_files[$i];
                                $supported_format = array('gif','jpg','jpeg','png','jfif');
                                $ext = strtolower(pathinfo($image_name, PATHINFO_EXTENSION));
                                if (in_array($ext, $supported_format)){
                                    echo '
                                        <tr>
                                            <td>
                                                <a href="'.$image_name.'" data-toggle="lightbox-image">
                                                    <img src="'.$image_name.'" alt="'.$image_name.'" class="img-responsive center-block" style="max-width: 110px;">
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                <label class="switch switch-primary">
                                                    <input type="checkbox"><span></span>
                                                </label>
                                                Publish
                                            </td>
                                            <td class="text-center">
                                                <a href="javascript:void(0)" id="delete_image" data-id="'.$image_name.'" dat class="btn btn-xs btn-danger"><i class="fa fa-trash-o"></i> Delete</a>
                                            </td>
                                        </tr> 
                                    ';
                                    //echo '<img src="'.$image_name .'" alt="'.$image_name.'" />'."<br /><br />";
                                } else {
                                     continue;
                                }
                            }

                        ?>
                       
                    </tbody>
                </table>
                <!-- END Product Images Content -->
            </div>
            <!-- END Product Images Block -->
        </div>
    </div>
    <!-- END Product Edit Content -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- ckeditor.js, load it only in the page you would like to use CKEditor (it's a heavy plugin to include it with the others!) -->
<script src="js/helpers/ckeditor/ckeditor.js"></script>
<script>
      $(document).ready(function() {
            $('#storage_variation').hide()
            $("#false").click(function(e){
                e.preventDefault()
               $("#storage_variation").toggle(false);
            });

            $("#true").click(function(e){
              e.preventDefault()
               $("#storage_variation").toggle(true);
            });

            //refresh div
            //setTimeout(function() { $("#load_images").reload(1000); }, 1000)

            setInterval(
            function(){
                $('#load_images').load(' #load_images');
            },1000);

            $(document).on('click', '#delete_image', function() { 
                var product_id = $(this).attr('data-id');
                
                $.ajax({
                    type: "post",
                    url: "delete_image.php",
                    data: {product_id: product_id},
                    success: function (response) {
                        
                        if(response == 1) {
                            toastr.info('Image Deleted successfully', 'success');
                        } else if(response == 2) {
                            toastr.info('Deleting image failed', 'danger');
                        } else {
                            toastr.info(response, 'danger');
                        }
                     
                    }
                });
            })

            //count meta title
            function textLength(value){
                var maxLength = 60;
                if(value.length > maxLength) 
                return false;
                return true;
            }
            
            document.getElementById('meta_title').onkeyup = function(){
                if(!textLength(this.value)) {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "red";
                } else {
                    var count = this.value.length
                    $('#count_c').text(count)
                    document.getElementById("count_c").style.color = "grey";
                }
            }

            //count meta description
            var editor = CKEDITOR.replace( 'meta_desc', {});
            editor.on( "pluginsLoaded", function( event ){
                editor.on( 'contentDom', function( evt ) {
                    var editable = editor.editable();                   
                    editable.attachListener( editable, 'keyup', function( e ) { 
                        // do something
                        
                        var size = editor.getData().replace(/<[^>]*>/g, '').replace(/\s+/g, ' ').replace(/&\w+;/g ,'X').replace(/^\s*/g, '').replace(/\s*$/g, '').length;
                        if(size > 150) {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "red";
                        } else {
                            var count = size
                            $('#count_d').text(count)
                            document.getElementById("count_d").style.color = "grey";
                        }
                    });
                }); 
            });
        })
</script>
<?php include 'inc/template_end.php'; ?>