<?php
include_once "inc/dbconn.php";
// Ensure user is logged in
if (!isset($_SESSION['uid'])) {
    echo "<script>alert('You must be logged in.'); location.href='login.php';</script>";
    exit;
}

$userid = $_SESSION['uid'];
$category_name = trim($_POST['category_name']);

if (empty($category_name)) {
    echo "<script>alert('Category name cannot be empty.'); location.href='blog_categories.php';</script>";
    exit;
}

// Check for duplicates
$check = $connection->prepare("SELECT id FROM blog_categories WHERE category_name = ?");
$check->bind_param("s", $category_name);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo "<script>alert('This category already exists.'); location.href='blog_categories.php';</script>";
    exit;
}

// Insert category
$stmt = $connection->prepare("INSERT INTO blog_categories (category_name, created_by) VALUES (?, ?)");
$stmt->bind_param("si", $category_name, $userid);

if ($stmt->execute()) {
    echo "<script>alert('Category added successfully.'); location.href='blog_categories.php';</script>";
} else {
    echo "<script>alert('Failed to add category. Please try again.'); location.href='blog_categories.php';</script>";
}
?>
