<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once "inc/dbconn.php";

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    // Validate and sanitize inputs
    $partner_name = trim($_POST['name']);
    $website_url = trim($_POST['website_url']);
    
    if (empty($partner_name) || empty($website_url)) {
        echo "<script>alert('All fields are required.'); location.href='partners.php';</script>";
        exit();
    }

    // Validate file upload
    if (!isset($_FILES['logo']) || $_FILES['logo']['error'] !== UPLOAD_ERR_OK) {
        echo "<script>alert('Logo upload failed.'); location.href='partners.php';</script>";
        exit();
    }

    $allowed_ext = ['jpg', 'jpeg', 'png', 'webp', 'svg'];
    $file_size = $_FILES['logo']['size'];
    $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    
    if (!in_array($ext, $allowed_ext)) {
        echo "<script>alert('Invalid logo type. Only JPG, PNG, WEBP, or SVG allowed.'); location.href='partners.php';</script>";
        exit();
    }


    if ($file_size > 2 * 1024 * 1024) { // 2MB max
        echo "<script>alert('Logo file too large. Max 2MB allowed.'); location.href='partners.php';</script>";
        exit();
    }

    // Prepare upload path
    $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
    $logo_filename = uniqid('partner_', true) . '.' . $ext;
    $upload_dir = '../partner_logos/';
    $upload_path = $upload_dir . $logo_filename;

    // Create directory if it doesn't exist
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    // Move the file
    if (!move_uploaded_file($_FILES['logo']['tmp_name'], $upload_path)) {
        echo "<script>alert('Failed to save logo.'); location.href='partners.php';</script>";
        exit();
    }

    // Insert into database
    $stmt = $connection->prepare("INSERT INTO partners (name, website_url, logo) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $partner_name, $website_url, $logo_filename);

    if ($stmt->execute()) {
        echo "<script>alert('Partner added successfully.'); location.href='partners.php';</script>";
    } else {
        echo "<script>alert('Database error.'); location.href='partners.php';</script>";
    }

    $stmt->close();
    $connection->close();
} else {
    echo "<script>alert('Invalid request.'); location.href='partners.php';</script>";
}
?>
