<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>

<!-- Page content -->
<div id="page-content">
    <!-- Datatables Header -->
    <div class="content-header">
        <div class="header-section">
            <h1>
                <i class="fa fa-table"></i>Delete<br><small>Set Delete Password</small>
            </h1>
        </div>
    </div>
    <ul class="breadcrumb breadcrumb-top">
        <li>Pages</li>
        <li><a href="">Delete Password</a></li>
    </ul>
    <!-- END Datatables Header -->

    <!-- Datatables Content -->
    <div class="block full">
        <div class="add_user_btn ">
            <a href="#"  onclick="$('#modal-delete-password').modal('show');" class="text-decoration-none"> <h2><i class="fa fa-plus-circle text-success"></i><span class="ml-20">Create | Update Password</span></h2></a>
        </div>

    </div>
    <!-- END Datatables Content -->
</div>
<!--Modal Content -->
<div id="modal-delete-password" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header text-center">
                <h2 class="modal-title"><i class="fa fa-pencil"></i> Create | Update Password</h2>
            </div>
            <!-- END Modal Header -->

            <!-- Modal Body -->
            <div class="modal-body">
                <form action="save_password.php" method="post" enctype="multipart/form-data" class="form-horizontal form-bordered" >
                   
                    <fieldset>
                        <legend>Password </legend>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-password">Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-password" name="password" class="form-control" placeholder="Please choose a complex one.." required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label" for="user-settings-repassword">Confirm Password</label>
                            <div class="col-md-8">
                                <input type="password" id="user-settings-repassword" name="confirm_password" class="form-control" placeholder="..and confirm it!" required>
                            </div>
                        </div>
                    </fieldset>
                    <div class="form-group form-actions">
                        <div class="col-xs-12 text-right">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" id="submit_btn" name="submit" class="btn btn-sm btn-primary">Save Changes</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END Modal Body -->
        </div>
    </div>
</div>

<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/tablesDatatables.js"></script>
<script>$(function(){ TablesDatatables.init(); });</script>

<?php include 'inc/template_end.php'; ?>

<script>
    $(document).ready(function(){
        $(document).on('click', '#edit_user', function(e){
            e.preventDefault();
            var user_id = $(this).attr('data-id');
            var pathname = window.location.href
            var url = new URL(pathname);
            url.searchParams.set("user", user_id); // setting your param
            var newUrl = url.href; 
            
            window.location.href = newUrl;
           
        })
        $.extend({
            getUrlVars: function(){
                var vars = [], hash;
                var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
                for(var i = 0; i < hashes.length; i++)
                {
                hash = hashes[i].split('=');
                vars.push(hash[0]);
                vars[hash[0]] = hash[1];
                }
                return vars;
            },
            getUrlVar: function(name){
                return $.getUrlVars()[name];
            }
        });

        if ($.getUrlVar("user") != null) {
            $('#modal-edit-user').modal('show');
        }
    })
</script>