<?php
header('Content-Type: application/json');
require_once '../../inc/dbconn.php';

try{
    $pdo->beginTransaction();

    $user_id = $_SESSION['user_id'] ?? null;
    $first_name = $_POST['first_name'];
    $last_name  = $_POST['last_name'];
    $email      = $_POST['email'];
    $phone      = $_POST['phone'];
    $password   = !empty($_POST['password']) ? password_hash($_POST['password'], PASSWORD_DEFAULT) : null;
    $address    = $_POST['address'];
    $city       = $_POST['city'];
    $notes      = $_POST['notes'] ?? '';

    if($user_id){
        // ✅ Update existing user
        if($password){
            $stmt = $pdo->prepare("UPDATE users SET username=?, email=?, phone=?, password=? WHERE id=?");
            $stmt->execute([$first_name, $email, $phone, $password, $user_id]);
        } else {
            $stmt = $pdo->prepare("UPDATE users SET username=?, email=?, phone=? WHERE id=?");
            $stmt->execute([$first_name, $email, $phone, $user_id]);
        }

        // ✅ Update shipping
        $stmt2 = $pdo->prepare("UPDATE shipping SET first_name=?, last_name=?, email=?, phone=?, address=? WHERE user_id=?");
        $stmt2->execute([$first_name, $last_name, $email, $phone, $address.', '.$city, $user_id]);

    } else {
        // Insert new user
        $stmt = $pdo->prepare("INSERT INTO users (username,email,phone,password,privileges,created_by) VALUES (?,?,?,?,?,?)");
        $stmt->execute([$first_name, $email, $phone, $password, 'customer', 0]);
        $user_id = $pdo->lastInsertId();

        // Insert shipping
        $stmt2 = $pdo->prepare("INSERT INTO shipping (user_id,first_name,last_name,email,phone,address) VALUES (?,?,?,?,?,?)");
        $stmt2->execute([$user_id, $first_name, $last_name, $email, $phone, $address.', '.$city]);
    }

    // ✅ Cart total & Paystack reference
    $cartTotal = 0;
    if(empty($_SESSION['cart'])) throw new Exception("Cart is empty.");

    foreach($_SESSION['cart'] as $item){
        $cartTotal += $item['price'] * $item['quantity'];
    }

    $reference = 'WKIREI_'.uniqid();

    // Insert order
    $stmtOrder = $pdo->prepare("INSERT INTO orders (user_id,name,email,phone,address,notes,total_amount,payment_method,reference) VALUES (?,?,?,?,?,?,?,?,?)");
    $stmtOrder->execute([$user_id, $first_name.' '.$last_name, $email, $phone, $address.', '.$city, $notes, $cartTotal, 'Paystack', $reference]);
    $order_id = $pdo->lastInsertId();

    // Insert order items
    $stmtItem = $pdo->prepare("INSERT INTO order_items (order_id, product_id, product_name, product_price, product_qty, subtotal) VALUES (?,?,?,?,?,?)");
    foreach($_SESSION['cart'] as $item){
        $subtotal = $item['price'] * $item['quantity'];
        $stmtItem->execute([$order_id, $item['id'], $item['name'], $item['price'], $item['quantity'], $subtotal]);
    }

    // Insert into paystack_payments
    $stmt3 = $pdo->prepare("INSERT INTO paystack_payments (email,user_id,amount,status,transaction,reference,message) VALUES (?,?,?,?,?,?,?)");
    $stmt3->execute([$email,$user_id,$cartTotal,'pending','',$reference,'Pending payment']);

    $pdo->commit();

    echo json_encode([
        'status'=>'success',
        'email'=>$email,
        'amount'=>$cartTotal,
        'reference'=>$reference
    ]);

}catch(Exception $e){
    $pdo->rollBack();
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
}
?>
