<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once '../../inc/dbconn.php'; // This should now return a PDO instance in $pdo
require '../../../vendor/autoload.php';

header('Content-Type: application/json');

function response($status, $message) {
    echo json_encode(['status'=>$status, 'message'=>$message]);
    exit;
}

// Validate POST
if(empty($_POST['first_name']) || empty($_POST['last_name']) || empty($_POST['email']) || empty($_POST['subject']) || empty($_POST['message'])) {
    response('error', 'All fields are required.');
}

$first_name = trim($_POST['first_name']);
$last_name  = trim($_POST['last_name']);
$email      = trim($_POST['email']);
$subject    = trim($_POST['subject']);
$message    = trim($_POST['message']);
$phone      = isset($_POST['phone']) ? trim($_POST['phone']) : null;
$ip_address = $_SERVER['REMOTE_ADDR'];
$created_at = date('Y-m-d H:i:s');
$name_full  = $first_name.' '.$last_name;

try {
    // Save to database using PDO
    $stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, subject, message, created_at, phone, ip_address) VALUES (:name, :email, :subject, :message, :created_at, :phone, :ip_address)");
    $stmt->execute([
        ':name'       => $name_full,
        ':email'      => $email,
        ':subject'    => $subject,
        ':message'    => $message,
        ':created_at' => $created_at,
        ':phone'      => $phone,
        ':ip_address' => $ip_address
    ]);
} catch (PDOException $e) {
    response('error', 'Failed to save your message: '.$e->getMessage());
}

// Send email using PHPMailer
// Send acknowledgment email to user
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'mail.smartphonecity.ke';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'sales@smartphonecity.ke';
    $mail->Password   = 'njirainicanon.m';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    $mail->setFrom('sales@smartphonecity.ke', 'W.Kirei');
    $mail->addAddress($email, $name_full); // Send to the user
    $mail->addReplyTo('info@smartphonecity.ke', 'W.Kirei');

    $mail->isHTML(true);
    $mail->Subject = 'We Received Your Message';

    // Modern, clean HTML email body
    $mail->Body = "
        <div style='font-family:Arial,sans-serif; color:#333; max-width:600px; margin:auto; padding:20px; border:1px solid #eee; border-radius:10px; background-color:#f9f9f9;'>
            <h2 style='color:#1a73e8;'>Hello {$first_name},</h2>
            <p style='font-size:16px;'>Thank you for reaching out to us! We have successfully received your message and our team is reviewing it.</p>
            <div style='margin:20px 0; padding:15px; background:#ffffff; border-left:5px solid #1a73e8;'>
                <p><b>Subject:</b> {$subject}</p>
                <p><b>Your Message:</b></p>
                <p style='margin-left:10px;'>{$message}</p>
            </div>
            <p style='font-size:16px;'>Our team will get back to you as soon as possible. In the meantime, feel free to explore our website for more information.</p>
            <p style='margin-top:30px; font-size:14px; color:#666;'>– The W.Kirei Team</p>
            <hr style='border:none; border-top:1px solid #eee; margin:20px 0;'>
            <p style='font-size:12px; color:#999;'>If you did not send this message, please ignore this email.</p>
        </div>
    ";

    $mail->send();
    response('success', 'Thank you! Your message has been received. A confirmation email has been sent to you.');
} catch (Exception $e) {
    response('error', 'Message saved but failed to send confirmation email. Mailer Error: '.$mail->ErrorInfo);
}
