<?php
include '../../inc/dbconn.php';
header('Content-Type: application/json');

try {
    $limit = 5; // blogs per page
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $offset = ($page - 1) * $limit;

    // Count total published blogs
    $total_stmt = $pdo->query("SELECT COUNT(*) FROM blog WHERE publish_status = '1'");
    $total_blogs = $total_stmt->fetchColumn();
    $total_pages = ceil($total_blogs / $limit);

    // Fetch blog data
    $stmt = $pdo->prepare("
        SELECT id, blog_title, slug, blog_image, excerpt, meta_title, meta_description, author, date, tags 
        FROM blog 
        WHERE publish_status = '1' 
        ORDER BY date DESC 
        LIMIT :limit OFFSET :offset
    ");
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    $blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Process blogs (handle images and content)
    foreach ($blogs as &$blog) {
        // Get first image
        $images = explode(',', $blog['blog_image']);
        $first_image = trim($images[0] ?? '');
        $blog['first_image'] = $first_image ? "blog_images/" . $first_image : "assets/images/blog/default.jpg";

        // Load blog text from blog/{id}.txt
        $file_path = "../../blog/" . $blog['id'] . ".txt";
        if (file_exists($file_path)) {
            $content = file_get_contents($file_path);
            $blog['content'] = mb_substr(strip_tags($content), 0, 200) . '...';
        } else {
            $blog['content'] = $blog['excerpt'] ?: "No preview available.";
        }
    }

    echo json_encode([
        'status' => 'success',
        'blogs' => $blogs,
        'total_pages' => $total_pages,
        'current_page' => $page
    ]);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
