<?php
include '../../inc/dbconn.php';
header('Content-Type: application/json');

if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid product ID']);
    exit;
}

$product_id = intval($_POST['id']);

try {
    $stmt = $pdo->prepare("SELECT product_id, product_title, product_price, product_image FROM products WHERE product_id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$product) {
        echo json_encode(['status' => 'error', 'message' => 'Product not found']);
        exit;
    }

    // 🖼️ Handle multiple images — use the first one
    $images = explode(',', $product['product_image']);
    $first_image = trim($images[0]); // Remove whitespace

    if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];

    if (isset($_SESSION['cart'][$product_id])) {
        $_SESSION['cart'][$product_id]['quantity']++;
    } else {
        $_SESSION['cart'][$product_id] = [
            'id' => $product['product_id'],
            'name' => $product['product_title'],
            'price' => floatval($product['product_price']),
            'image' => $first_image,
            'quantity' => 1
        ];
    }

    // 🛒 Build cart HTML
    ob_start();
    $subtotal = 0;
    echo '<ul>';
    foreach ($_SESSION['cart'] as $item) {
        $subtotal += $item['price'] * $item['quantity'];
        echo '
        <li>
            <div class="img_content">
                <img class="product-image img-responsive" 
                     src="product_images/' . htmlspecialchars($item['image']) . '" 
                     alt="' . htmlspecialchars($item['name']) . '" 
                     style="width:100px;height:auto;object-fit:contain;">
                <span class="product-quantity">' . $item['quantity'] . 'x</span>
            </div>
            <div class="right_block">
                <span class="product-name">' . htmlspecialchars($item['name']) . '</span>
                <span class="product-price">Ksh ' . number_format($item['price'], 2) . '</span>
                <a href="#" class="remove-from-cart" data-id="' . $item['id'] . '">
                    <i class="fa fa-remove pull-xs-left"></i>
                </a>
            </div>
        </li>';
    }
    echo '</ul>';
    echo '
        <div class="price_content">
            <div class="cart-total price_inline">
                <span class="label">Total</span>
                <span class="value">Ksh ' . number_format($subtotal, 2) . '</span>
            </div>
        </div>
        <div class="checkout">
            <a href="cart.php" class="btn btn-primary">View Cart</a>
        </div>
    ';
    $cartHTML = ob_get_clean();

    echo json_encode([
        'status' => 'success',
        'message' => $product['product_title'] . ' added to cart!',
        'cart_html' => $cartHTML,
        'cart_count' => array_sum(array_column($_SESSION['cart'], 'quantity')),
        'cart_total' => $subtotal
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
