<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../../inc/dbconn.php';

try {
    // Fetch 3 random active products
    $stmt = $pdo->prepare("
        SELECT 
            product_id, 
            product_title, 
            slug, 
            product_price, 
            old_price, 
            product_image 
        FROM products 
        WHERE product_status = 'on'
        ORDER BY RAND() 
        LIMIT 3
    ");
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$products) {
        echo json_encode(['status' => 'error', 'message' => 'No products found.']);
        exit;
    }

    echo json_encode([
        'status' => 'success',
        'products' => $products
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
