<?php
include_once 'inc/navigation.php';
?>

        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span>Blog</span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- cart page content -->
        <div class="blog-page-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9">

                        <div class="page-content blog-page blog-sidebar right-sidebar blog-text-align" id="blog-list"></div>
                        <div class="pagination d-flex justify-content-center mt-4" id="pagination"></div>

                        
                    </div>
                    <div class="col-lg-3">
                        <div class="blog_sidebar">
                            <div class="row_products_side">
                                <div class="product_left_sidbar">
                                    <div class="product-filter  mb-30">
                                        <h5>Search </h5>
                                        <div class="search__sidbar">
                                            <div class="input_form">
                                            <input type="text" id="search_input" name="s" value="Search..." class="input_text">
                                            <button id="blogsearchsubmit" type="submit" class="button">
                                                <i class="fa fa-search"></i>
                                            </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="product-filter  mb-30">
                                        <h5>Categories</h5>
                                        <div class="blog_Archives__sidbar">
                                            <ul>
                                                <?php
                                                try {
                                                    // Fetch categories with post counts
                                                    $stmt = $pdo->query("
                                                        SELECT c.id, c.category_name, COUNT(b.id) AS post_count
                                                        FROM blog_categories c
                                                        LEFT JOIN blog b ON b.category_id = c.id AND b.publish_status = '1'
                                                        GROUP BY c.id
                                                        ORDER BY post_count DESC, c.category_name ASC
                                                    ");

                                                    if ($stmt->rowCount() > 0) {
                                                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $categoryName = htmlspecialchars($row['category_name']);
                                                            $count = (int)$row['post_count'];

                                                            echo "
                                                                <li>
                                                                    <a href='blog.php?category={$row['id']}'>{$categoryName}</a>&nbsp;({$count})
                                                                </li>
                                                            ";
                                                        }
                                                    } else {
                                                        echo "<li>No categories available yet.</li>";
                                                    }
                                                } catch (PDOException $e) {
                                                    echo "<li>Error fetching categories: " . htmlspecialchars($e->getMessage()) . "</li>";
                                                }
                                                ?>
                                            </ul>
                                        </div>

                                    </div>
                                    <div class="product-filter  mb-30">
                                       <h5>Recent Posts</h5>
                                        <div class="blog_Archives__sidbar">
                                            <ul>
                                                <?php
                                                // Fetch the 5 most recent published blogs
                                                $stmt = $pdo->query("
                                                    SELECT 
                                                        b.id, 
                                                        b.blog_title, 
                                                        b.slug, 
                                                        (SELECT COUNT(*) FROM comments c WHERE c.post_id = b.id) AS comment_count
                                                    FROM blog b
                                                    WHERE b.publish_status = '1'
                                                    ORDER BY b.date DESC
                                                    LIMIT 5
                                                ");

                                                if ($stmt->rowCount() > 0) {
                                                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                        $title = htmlspecialchars($row['blog_title']);
                                                        $slug = htmlspecialchars($row['slug']);
                                                        $count = (int)$row['comment_count'];
                                                        echo "
                                                            <li>
                                                                <a href='blog/{$slug}.php'>{$title}</a>&nbsp;({$count})
                                                            </li>
                                                        ";
                                                    }
                                                } else {
                                                    echo "<li>No recent posts available.</li>";
                                                }
                                                ?>
                                            </ul>
                                        </div>

                                    </div>
                                    <div class="sidebar-single-banner">
                                        <a href="#">
                                            <img src="images/new_images/side_banner.webp" alt="<?= $site_name ?>" loading="lazy">
                                        </a>
                                    </div>
                                    <div class="product-filter mb-30">
                                        <h5>Product Tags</h5>
                                        <div class="blog-tags">
                                            <a href="#">J-beauty</a>
                                            <a href="#">skincare</a>
                                            <a href="#">moisturizer</a>
                                            <a href="#">serum</a>
                                            <a href="#">facial mask</a>
                                            <a href="#">sunscreen</a>
                                            <a href="#">natural extracts</a>
                                            <a href="#">anti-aging</a>
                                            <a href="#">glowing skin</a>
                                            <a href="#">beauty routine</a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- cart page content end -->
<?php
include_once 'inc/footer.php';
?>
<script src="js/action/fetch_blogs.js"></script>
