<?php
include_once 'inc/navigation.php'
?>
        <!-- top breadcrumb -->
        <div class="top_breadcrumb">                 
            <div class="breadcrumb_container ">
                <div class="container">
                    <nav data-depth="3" class="breadcrumb">
                        <ol>
                            <li>
                                <a href="index.php">
                                <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                <span>Cart</span>
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div> 
        </div>
        <!-- top breadcrumb end -->

        <!-- cart page content -->
        <div class="cart-page-area">
            <div class="container">
                <!-- Form Start -->
               <?php
                // If cart is empty, initialize
                $cartItems = $_SESSION['cart'] ?? [];
                $cartTotal = 0;
                ?>

                <form action="#" method="post">
                    <!-- Table Content Start -->
                    <div class="table-content table-responsive mb-50">
                        <table>
                            <thead>
                                <tr>
                                    <th class="product-thumbnail">Image</th>
                                    <th class="product-name">Product</th>
                                    <th class="product-price">Price</th>
                                    <th class="product-quantity">Quantity</th>
                                    <th class="product-subtotal">Total</th>
                                    <th class="product-remove">Remove</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($cartItems)): ?>
                                    <?php foreach ($cartItems as $key => $item):
                                        $subtotal = $item['price'] * $item['quantity'];
                                        $cartTotal += $subtotal;
                                    ?>
                                    <tr>
                                        <td class="product-thumbnail">
                                            <a href="#">
                                                <img src="product_images/<?php echo htmlspecialchars($item['image']); ?>" 
                                                    alt="<?php echo htmlspecialchars($item['name']); ?>" 
                                                    style="width:80px;height:80px;object-fit:cover;border-radius:8px;">
                                            </a>
                                        </td>
                                        <td class="product-name"><a href="#"><?php echo htmlspecialchars($item['name']); ?></a></td>
                                        <td class="product-price"><span class="amount">Ksh <?php echo number_format($item['price'], 2); ?></span></td>
                                        <td class="product-quantity">
                                            <input type="number" name="quantity[<?php echo $key; ?>]" value="<?php echo $item['quantity']; ?>" min="1">
                                        </td>
                                        <td class="product-subtotal">Ksh <?php echo number_format($subtotal, 2); ?></td>
                                       <td class="product-remove">
                                            <a href="#" class="remove-item" data-key="<?php echo $key; ?>">
                                                <i class="fa fa-times" aria-hidden="true"></i>
                                            </a>
                                        </td>

                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center text-muted">Cart is empty.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- Table Content End -->

                    <div class="row">
                        <!-- Cart Buttons -->
                        <div class="col-md-8 col-sm-7">
                            <div class="buttons-cart">
                                <input type="submit" name="update_cart" value="Update Cart">
                                <a href="shop.php">Continue Shopping</a>
                            </div>
                        </div>
                        <!-- Cart Totals -->
                        <div class="col-md-4 col-sm-5">
                            <div class="cart_totals">
                                <h2>Cart Totals</h2>
                                <br>
                                <table>
                                    <tbody>
                                        <tr class="cart-subtotal">
                                            <th>Subtotal</th>
                                            <td><span class="amount">Ksh <?php echo number_format($cartTotal, 2); ?></span></td>
                                        </tr>
                                        <tr class="order-total">
                                            <th>Total</th>
                                            <td>
                                                <strong><span class="amount">Ksh <?php echo number_format($cartTotal, 2); ?></span></strong>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="wc-proceed-to-checkout">
                                    <a href="checkout.php">Proceed to Checkout</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Form End -->
            </div>
        </div>
        <!-- cart page content end -->
<?php
include_once 'inc/footer.php';
?>
<script>
$(document).ready(function() {
    $('.remove-item').on('click', function(e) {
        e.preventDefault();
        let key = $(this).data('key');

        $.ajax({
            url: 'api/cart/cart_action.php',
            type: 'POST',
            data: { action: 'remove', key: key },
            dataType: 'json', // tell jQuery to expect JSON
            success: function(res) {  // no JSON.parse needed
                if(res.status === 'success') {
                    $('.table-content table tbody').html(res.cart_html);
                    $('.cart_totals .amount').text('Ksh ' + res.cart_total.toFixed(2));
                } else {
                    alert('Failed to remove item: ' + res.message);
                }
            },
            error: function() {
                alert('Something went wrong. Please try again.');
            }
        });

    });
});
</script>
