$(document).ready(function() {
    $("#newsletterForm").on("submit", function(e) {
        e.preventDefault();

        const email = $("#newsletterEmail").val().trim();
        const btn = $("#subscribeBtn");
        const spinner = btn.find(".spinner-border");
        const btnText = btn.find(".btn-text");

        if (email === "") {
            toastr.warning("Please enter your email address.");
            return;
        }

        // UI feedback
        btn.prop("disabled", true);
        btnText.text("Processing...");
        spinner.removeClass("d-none");

        $.ajax({
            url: "api/action/subscribe.php",
            method: "POST",
            data: { email },
            dataType: "json",
            success: function(response) {
                console.log("✅ AJAX Success Response:", response);

                if (response.status === "success") {
                    toastr.success(response.message);
                    $("#newsletterEmail").val("");
                } else {
                    toastr.error(response.message || "Unexpected error.");
                }
            },
            error: function(xhr, status, error) {
                console.group("❌ AJAX Error Details");
                console.error("Status:", status);
                console.error("Error Thrown:", error);
                console.error("Response Text:", xhr.responseText);
                console.error("XHR Object:", xhr);
                console.groupEnd();

                toastr.error("Something went wrong. Please check console logs for details.");
            },
            complete: function() {
                btn.prop("disabled", false);
                btnText.text("Subscribe");
                spinner.addClass("d-none");
            }
        });
    });
});
