document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.quick_view').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const productId = this.getAttribute('data-id');
            
            fetch('api/products/fetch_product.php?id=' + productId)
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        const p = data.product;

                        // Update name, ref, prices, desc
                        document.getElementById('productName').innerText = p.title;
                        document.getElementById('productRef').innerText = "Reference: " + p.slug;
                        document.getElementById('newPrice').innerText = "Ksh " + p.price;
                        document.getElementById('oldPrice').innerText = "Ksh " + p.old_price;
                        document.getElementById('productDesc').innerText = p.description;

                        // ✅ Hide old price if <= 0
                        const oldPriceEl = document.getElementById('oldPrice');
                        if (parseFloat(p.old_price) <= 0) {
                            oldPriceEl.style.display = 'none';
                        } else {
                            oldPriceEl.style.display = 'inline';
                        }

                        // Calculate discount percentage
                        let discountText = '';
                        if (p.old_price > 0 && p.price < p.old_price) {
                            const discount = Math.round(((p.old_price - p.price) / p.old_price) * 100);
                            discountText = `Save ${discount}%`;
                        }
                        document.getElementById('discountText').innerText = discountText;

                        // Update images (up to 4)
                        const thumbs = ['thumb1','thumb2','thumb3','thumb4'];
                        const tabImgs = ['img1','img2','img3','img4'];
                        const mainImage = document.getElementById('mainImage');

                        p.images.forEach((img, i) => {
                            if (thumbs[i]) {
                                const thumb = document.getElementById(thumbs[i]);
                                const tabImg = document.querySelector(`#${tabImgs[i]} img`);
                                const imagePath = 'product_images/' + img.trim();

                                thumb.src = imagePath;
                                if (tabImg) tabImg.src = imagePath;

                                if (i === 0) mainImage.src = imagePath;
                            }
                        });

                        // If fewer than 4 images, hide empty thumbs
                        for (let i = p.images.length; i < 4; i++) {
                            const li = document.querySelector(`li a[href="#${tabImgs[i]}"]`)?.closest('li');
                            if (li) li.style.display = 'none';
                        }

                    } else {
                        alert('Failed to load product details.');
                    }
                })
                .catch(err => console.error('Error fetching product:', err));
        });
    });
});